/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.table;

import java.util.Comparator;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.table.SquirrelTableCellValueCollator;
import net.sourceforge.squirrel_sql.fw.gui.table.TableSortingAdmin;
import net.sourceforge.squirrel_sql.fw.gui.table.TableSortingItem;

class TableModelComparator
implements Comparator<Integer> {
    private final TableModel _actualModel;
    private final TableSortingAdmin _tableSortingAdmin;
    private final SquirrelTableCellValueCollator _collator = new SquirrelTableCellValueCollator();
    private boolean _nullIsHighest;

    public TableModelComparator(TableModel actualModel, TableSortingAdmin tableSortingAdmin) {
        this._actualModel = actualModel;
        this._tableSortingAdmin = tableSortingAdmin;
        this._nullIsHighest = this.isSortNullsAsHighestValue();
        block0: for (TableSortingItem tableSortingItem : tableSortingAdmin.getTableSortingItems()) {
            tableSortingItem.setAllDataString(true);
            tableSortingItem.initAscendingInt();
            int limit = this._actualModel.getRowCount();
            for (int i = 0; i < limit; ++i) {
                Object data = this._actualModel.getValueAt(i, tableSortingItem.getSortedModelColumn());
                if (data instanceof String) continue;
                tableSortingItem.setAllDataString(false);
                continue block0;
            }
        }
    }

    @Override
    public int compare(Integer i1, Integer i2) {
        for (TableSortingItem tableSortingItem : this._tableSortingAdmin.getTableSortingItems()) {
            Object data2;
            Object data1 = this._actualModel.getValueAt(i1, tableSortingItem.getSortedModelColumn());
            int res = this._collator.compareTableCellValues(data1, data2 = this._actualModel.getValueAt(i2, tableSortingItem.getSortedModelColumn()), tableSortingItem.getAscendingInt(), tableSortingItem.isAllDataString(), this._nullIsHighest);
            if (0 == res) continue;
            return res;
        }
        return 0;
    }

    public boolean isSortNullsAsHighestValue() {
        boolean nullIsHighest = null != Main.getApplication().getSessionManager().getActiveSession() ? Main.getApplication().getSessionManager().getActiveSession().getProperties().isSortNullsAsHighestValue() : Main.getApplication().getSquirrelPreferences().getSessionProperties().isSortNullsAsHighestValue();
        return nullIsHighest;
    }
}

