/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import net.sourceforge.squirrel_sql.fw.gui.ColumnOrder;
import net.sourceforge.squirrel_sql.fw.gui.table.TableSortingItem;
import net.sourceforge.squirrel_sql.fw.resources.LibraryResources;

public class TableSortingAdmin {
    private final Icon _ascIcon;
    private final Icon _descIcon;
    private List<TableSortingItem> _tableSortingItems = new ArrayList<TableSortingItem>();
    private TableSortingItem _lastChangedSortingItem;

    public TableSortingAdmin() {
        LibraryResources rsrc = new LibraryResources();
        this._descIcon = rsrc.getIcon("table.descending");
        this._ascIcon = rsrc.getIcon("table.ascending");
    }

    public void updateSortedColumn(int sortedColumn, ColumnOrder columnOrder, boolean clearFirst) {
        if (clearFirst) {
            this.clear();
        }
        if (columnOrder == ColumnOrder.NATURAL) {
            this._tableSortingItems.removeIf(si -> si.getSortedModelColumn() == sortedColumn);
            return;
        }
        Icon sortedColumnIcon = columnOrder == ColumnOrder.ASC ? this._ascIcon : this._descIcon;
        Optional<TableSortingItem> match = this._tableSortingItems.stream().filter(si -> si.getSortedModelColumn() == sortedColumn).findFirst();
        if (match.isPresent()) {
            match.get().setOrder(columnOrder, sortedColumnIcon);
            this._lastChangedSortingItem = match.get();
        } else {
            TableSortingItem newTableSortingItem = new TableSortingItem(sortedColumn, columnOrder, sortedColumnIcon);
            this._tableSortingItems.add(newTableSortingItem);
            this._lastChangedSortingItem = newTableSortingItem;
        }
    }

    public void clear() {
        this._tableSortingItems.clear();
    }

    public List<TableSortingItem> getTableSortingItems() {
        return this._tableSortingItems;
    }

    public TableSortingItem getTableSortingItem(int sortModelColumn) {
        return this._tableSortingItems.stream().filter(si -> si.getSortedModelColumn() == sortModelColumn).findFirst().orElse(null);
    }

    public boolean hasSortedColumns() {
        return false == this._tableSortingItems.isEmpty();
    }

    public TableSortingItem getLastChangedSortingItem() {
        return this._lastChangedSortingItem;
    }
}

