/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.textfind;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.EditableComboBoxHandler;
import net.sourceforge.squirrel_sql.fw.gui.textfind.MatchBounds;
import net.sourceforge.squirrel_sql.fw.gui.textfind.TextFindMode;
import net.sourceforge.squirrel_sql.fw.gui.textfind.TextFindPanel;
import net.sourceforge.squirrel_sql.fw.gui.textfind.TextFinder;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class TextFindCtrl {
    public static final String PREF_KEY_TEXT_FIND_PREF_PREFIX = "TextFindCtrl.PREF_KEY_TEXT_FIND_PREF_PREFIX";
    public static final String PREF_KEY_SELECTED_TEXT_MODE = "TextFindCtrl.PREF_KEY_SELECTED_TEXT_MODE";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TextFindCtrl.class);
    private final JTextComponent _textComponentToSearch;
    private final JScrollPane _textComponentToSearchScrollPane;
    private final boolean _permanent;
    private final JPanel _containerPanel;
    private final TextFindPanel _findPanel;
    private final EditableComboBoxHandler _editableComboBoxHandler;
    int _nextOccurrenceToFind = 1;
    private String _lastTextToFind;
    private DefaultHighlighter.DefaultHighlightPainter _highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.orange);

    public TextFindCtrl(JTextComponent textComponentToSearch, JScrollPane textComponentToSearchScrollPane) {
        this(textComponentToSearch, textComponentToSearchScrollPane, false);
    }

    public TextFindCtrl(JTextComponent textComponentToSearch, JScrollPane textComponentToSearchScrollPane, boolean permanent) {
        this._textComponentToSearch = textComponentToSearch;
        this._textComponentToSearchScrollPane = textComponentToSearchScrollPane;
        this._permanent = permanent;
        this._containerPanel = new JPanel(new BorderLayout());
        if (null != textComponentToSearchScrollPane) {
            this._containerPanel.add((Component)this._textComponentToSearchScrollPane, "Center");
        } else {
            this._containerPanel.add((Component)this._textComponentToSearch, "Center");
        }
        this._findPanel = new TextFindPanel(this._permanent);
        this._editableComboBoxHandler = new EditableComboBoxHandler(this._findPanel.cboTextToFind, PREF_KEY_TEXT_FIND_PREF_PREFIX);
        this._findPanel.btnDown.addActionListener(e -> this.onFind(true));
        this._findPanel.btnUp.addActionListener(e -> this.onFind(false));
        this._findPanel.btnMarkAll.addActionListener(e -> this.onToggleMarkAll());
        this._findPanel.btnConfig.addActionListener(e -> this.onConfig());
        this._findPanel.btnHide.addActionListener(e -> this.closeFind());
        this.initKeyStrokes();
        if (this._permanent) {
            this.openFind();
        }
    }

    private void onConfig() {
        JPopupMenu popup = new JPopupMenu();
        TextFindMode selectedMode = TextFindCtrl.getSelectedFindMode();
        ButtonGroup bg = new ButtonGroup();
        for (TextFindMode mode : TextFindMode.values()) {
            JRadioButtonMenuItem radMnu = new JRadioButtonMenuItem(mode.getDisplayName());
            if (mode == selectedMode) {
                radMnu.setSelected(true);
            }
            radMnu.addActionListener(e -> Props.putString(PREF_KEY_SELECTED_TEXT_MODE, mode.name()));
            bg.add(radMnu);
            popup.add(radMnu);
        }
        popup.show(this._findPanel.btnConfig, 0, this._findPanel.btnConfig.getHeight());
    }

    private static TextFindMode getSelectedFindMode() {
        return TextFindMode.valueOf(Props.getString(PREF_KEY_SELECTED_TEXT_MODE, TextFindMode.CONTAINS_IGNORE_CASE.name()));
    }

    private void onFind(boolean next) {
        try {
            MatchBounds matchBounds;
            this._findPanel.btnMarkAll.setSelected(false);
            if (StringUtilities.isEmpty(this._editableComboBoxHandler.getItem(), true)) {
                Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("TextFindCtrl.text.to.find.missing"));
                this._nextOccurrenceToFind = 1;
                return;
            }
            this._editableComboBoxHandler.saveCurrentItem();
            this._textComponentToSearch.getHighlighter().removeAllHighlights();
            if (!this._editableComboBoxHandler.getItem().equals(this._lastTextToFind)) {
                this._nextOccurrenceToFind = 1;
            }
            this._lastTextToFind = this._editableComboBoxHandler.getItem();
            if (!next) {
                this._nextOccurrenceToFind = this._nextOccurrenceToFind > 2 ? (this._nextOccurrenceToFind -= 2) : 1;
            }
            if (null != (matchBounds = TextFinder.findNthOccurrence(this._textComponentToSearch.getText(), this._editableComboBoxHandler.getItem(), this._nextOccurrenceToFind, TextFindCtrl.getSelectedFindMode()))) {
                this._textComponentToSearch.setSelectionStart(matchBounds.getBeginIx());
                this._textComponentToSearch.setSelectionEnd(matchBounds.getBeginIx());
                this._textComponentToSearch.getHighlighter().addHighlight(matchBounds.getBeginIx(), matchBounds.getEndIx(), this._highlightPainter);
                ++this._nextOccurrenceToFind;
            } else {
                if (1 == this._nextOccurrenceToFind) {
                    String msg = s_stringMgr.getString("TextFindCtrl.could.not.find", this._editableComboBoxHandler.getItem());
                    Main.getApplication().getMessageHandler().showWarningMessage(msg);
                } else {
                    String msg = s_stringMgr.getString("TextFindCtrl.last.occurrence.reached", this._editableComboBoxHandler.getItem());
                    Main.getApplication().getMessageHandler().showMessage(msg);
                }
                this._nextOccurrenceToFind = 1;
            }
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private void onToggleMarkAll() {
        try {
            if (!this._findPanel.btnMarkAll.isSelected()) {
                this._textComponentToSearch.getHighlighter().removeAllHighlights();
                return;
            }
            if (StringUtilities.isEmpty(this._editableComboBoxHandler.getItem(), true)) {
                Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("TextFindCtrl.text.to.find.missing"));
                return;
            }
            int nextOccurrenceToFind = 1;
            MatchBounds matchBounds = TextFinder.findNthOccurrence(this._textComponentToSearch.getText(), this._editableComboBoxHandler.getItem(), nextOccurrenceToFind, TextFindCtrl.getSelectedFindMode());
            boolean firstMatch = true;
            while (null != matchBounds) {
                if (firstMatch) {
                    this._textComponentToSearch.setSelectionStart(matchBounds.getBeginIx());
                    this._textComponentToSearch.setSelectionEnd(matchBounds.getBeginIx());
                    firstMatch = false;
                }
                this._textComponentToSearch.getHighlighter().addHighlight(matchBounds.getBeginIx(), matchBounds.getEndIx(), this._highlightPainter);
                matchBounds = TextFinder.findNthOccurrence(this._textComponentToSearch.getText(), this._editableComboBoxHandler.getItem(), ++nextOccurrenceToFind, TextFindCtrl.getSelectedFindMode());
            }
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private void initKeyStrokes() {
        AbstractAction findNextAction = new AbstractAction("TextFindCtrl.FindNext"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextFindCtrl.this.onFindButtonKeyStroke(true);
            }
        };
        AbstractAction findPrevAction = new AbstractAction("TextFindCtrl.FindPrev"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextFindCtrl.this.onFindButtonKeyStroke(false);
            }
        };
        AbstractAction escapeAction = new AbstractAction("TextFindCtrl.Escape"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextFindCtrl.this._findPanel.btnHide.doClick();
            }
        };
        JComponent comp = (JComponent)this._findPanel.cboTextToFind.getEditor().getEditorComponent();
        comp.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(10, 0, false), 0);
        comp.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(114, 0, false), 0);
        comp.registerKeyboardAction(findPrevAction, KeyStroke.getKeyStroke(114, 64, false), 0);
        comp.registerKeyboardAction(escapeAction, KeyStroke.getKeyStroke(27, 0, false), 0);
    }

    private void onFindButtonKeyStroke(boolean next) {
        if (next) {
            this._findPanel.btnDown.doClick();
        } else {
            this._findPanel.btnUp.doClick();
        }
    }

    public JPanel getContainerPanel() {
        return this._containerPanel;
    }

    public void toggleFind() {
        if (1 == this._containerPanel.getComponents().length) {
            this.openFind();
        } else if (2 == this._containerPanel.getComponents().length) {
            this.closeFind();
        }
    }

    private void openFind() {
        this._containerPanel.remove(this._findPanel);
        this._containerPanel.add((Component)this._findPanel, "South");
        this._containerPanel.doLayout();
        this._findPanel.doLayout();
        this._findPanel.cboTextToFind.doLayout();
        this._editableComboBoxHandler.focus();
    }

    private void closeFind() {
        if (!this._permanent) {
            this._editableComboBoxHandler.saveCurrentItem();
            this._containerPanel.remove(this._findPanel);
            this._containerPanel.doLayout();
        }
        this._nextOccurrenceToFind = 1;
        this._findPanel.btnMarkAll.setSelected(false);
        this._textComponentToSearch.getHighlighter().removeAllHighlights();
    }
}

