/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.textfind;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.squirrel_sql.fw.gui.textfind.MatchBounds;
import net.sourceforge.squirrel_sql.fw.gui.textfind.TextFindMode;

public class TextFinder {
    public static MatchBounds findNthOccurrence(String text, String searchString, int n, TextFindMode textFindMode) {
        switch (textFindMode) {
            case CONTAINS: {
                return TextFinder.findNthOccurrence(text, searchString, n);
            }
            case CONTAINS_IGNORE_CASE: {
                return TextFinder.findNthOccurrenceIgnoreCase(text, searchString, n);
            }
            case CONTAINS_REG_EXP: {
                return TextFinder.findNthOccurrenceRegex(text, searchString, n);
            }
        }
        throw new IllegalArgumentException("Unknown TextFindMode " + textFindMode);
    }

    private static MatchBounds findNthOccurrenceIgnoreCase(String text, String searchString, int n) {
        String lowercaseText = text.toLowerCase();
        String lowercaseSearchString = searchString.toLowerCase();
        return TextFinder.findNthOccurrence(lowercaseText, lowercaseSearchString, n);
    }

    private static MatchBounds findNthOccurrence(String text, String searchString, int n) {
        int index = -1;
        for (int count = 0; count < n && (index = text.indexOf(searchString, index + 1)) != -1; ++count) {
        }
        if (-1 == index) {
            return null;
        }
        return new MatchBounds(index, index + searchString.length());
    }

    private static MatchBounds findNthOccurrenceRegex(String text, String regex, int n) {
        int count;
        int index = -1;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        MatchBounds ret = new MatchBounds();
        for (count = 0; count < n && matcher.find(index + 1); ++count) {
            index = matcher.start();
            ret.setBeginIx(index);
            ret.setEndIx(matcher.end());
        }
        return count == n ? ret : null;
    }
}

