/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.props;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.props.SortedProperties;
import net.sourceforge.squirrel_sql.fw.props.StringInterpreter;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class PropsImpl {
    private static final String NULL_PROP = "__<null>__";
    private Timer _propsWriteTimer;
    private final SortedProperties _properties;
    private static final ILogger s_log = LoggerController.createLogger(PropsImpl.class);

    public PropsImpl() {
        try {
            this._propsWriteTimer = new Timer(1000, e -> this.onWriteProps());
            this._propsWriteTimer.setRepeats(false);
            this._properties = new SortedProperties();
            File propsFile = new ApplicationFiles().getPropsFile();
            if (propsFile.exists()) {
                this._properties.load(new FileReader(propsFile));
            }
        }
        catch (IOException e2) {
            throw Utilities.wrapRuntime(e2);
        }
    }

    private void onWriteProps() {
        try {
            this._properties.store(new FileWriter(new ApplicationFiles().getPropsFile()), null);
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public void put(String propKey, int intValue) {
        this.putProperty(propKey, "" + intValue);
    }

    public int getInt(String propKey, int defaultIntValue) {
        return StringInterpreter.interpret(this.getProperty(propKey), Integer.class, defaultIntValue);
    }

    public boolean getBoolean(String propKey, boolean defaultBooleanValue) {
        return StringInterpreter.interpret(this.getProperty(propKey), Boolean.class, defaultBooleanValue);
    }

    public void put(String propKey, boolean booleanValue) {
        this.putProperty(propKey, "" + booleanValue);
    }

    public String getString(String propKey, String defaultString) {
        return this.getString(propKey, defaultString, false);
    }

    public String getString(String propKey, String defaultString, boolean allowWhiteSpacesOnly) {
        return StringInterpreter.interpret(this.getProperty(propKey), String.class, defaultString, allowWhiteSpacesOnly);
    }

    public void put(String propKey, String stringValue) {
        if (NULL_PROP.equals(stringValue)) {
            String msg = "The property value \"__<null>__\" cannot be read. When it is read null will be returned instead.";
            s_log.error(msg, new IllegalArgumentException(msg));
        }
        if (null == stringValue) {
            this.putProperty(propKey, NULL_PROP);
        } else {
            this.putProperty(propKey, stringValue);
        }
    }

    private String getProperty(String propKey) {
        String ret = null;
        String newProp = this._properties.getProperty(propKey);
        if (null != newProp) {
            ret = newProp;
        }
        if (NULL_PROP.equals(ret)) {
            return null;
        }
        return ret;
    }

    private void putProperty(String propKey, String oldPref) {
        this._properties.put(propKey, oldPref);
        this._propsWriteTimer.restart();
    }

    public void saveProperties() {
        this.onWriteProps();
    }
}

