/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.resources;

import java.net.URL;
import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.shortcut.ShortCutReader;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.JScrollMenu;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.resources.ResourceBundleHandler;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class Resources
implements IResources {
    private static final ILogger s_log = LoggerController.createLogger(Resources.class);
    private final ResourceBundleHandler _bundleHandler;
    private final ShortCutReader _shortCutReader;
    private ClassLoader _classLoader;

    protected Resources(String rsrcBundleBaseName, ClassLoader cl) {
        if (StringUtilities.isEmpty(rsrcBundleBaseName, true)) {
            throw new IllegalArgumentException("Null or empty rsrcBundleBaseName passed");
        }
        this._classLoader = cl;
        this._bundleHandler = new ResourceBundleHandler(rsrcBundleBaseName, cl);
        this._shortCutReader = new ShortCutReader(this._bundleHandler);
    }

    @Override
    public KeyStroke getKeyStroke(Action action) {
        Utilities.checkNull("getKeyStroke", "action", action);
        return this._shortCutReader.getShortcutAsKeyStroke(this.getFullMenuItemKey(action.getClass()), action);
    }

    public String getFullMenuItemKey(Class<? extends Action> actionClass) {
        return "menuitem." + actionClass.getName();
    }

    public String getAcceleratorString(Action action) {
        String fullKey = this.getFullMenuItemKey(action.getClass());
        return this.getAcceleratorString(action, fullKey, false);
    }

    private String getAcceleratorString(Action action, String fullKey, boolean forAppend) {
        String buf = this._shortCutReader.getShortcutAsString(fullKey, action);
        if (null == buf) {
            if (forAppend) {
                return "";
            }
            return null;
        }
        if (forAppend) {
            return "  (" + buf + ")";
        }
        return buf;
    }

    @Override
    public JMenuItem addToPopupMenu(Action action, JPopupMenu menu) throws MissingResourceException {
        String mn;
        Utilities.checkNull("addToPopupMenu", "action", action, "menu", menu);
        String fullKey = this.getFullMenuItemKey(action.getClass());
        JMenuItem item = menu.add(action);
        if (action.getValue("MnemonicKey") == null && (mn = this.getResourceString(fullKey, "mnemonic")).length() > 0) {
            item.setMnemonic(mn.charAt(0));
        }
        item.setAccelerator(this._shortCutReader.getShortcutAsKeyStroke(fullKey, action));
        String toolTipText = this.getToolTipText(action, fullKey, true);
        item.setToolTipText(toolTipText);
        return item;
    }

    @Override
    public JCheckBoxMenuItem addToMenuAsCheckBoxMenuItem(Action action, JMenu menu) throws MissingResourceException {
        Utilities.checkNull("addToMenuAsCheckBoxMenuItem", "action", action, "menu", menu);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.configureMenuItem(action, item);
        return item;
    }

    @Override
    public JCheckBoxMenuItem addToMenuAsCheckBoxMenuItem(Action action, JPopupMenu popupMenu) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        popupMenu.add(item);
        this.configureMenuItem(action, item);
        return item;
    }

    @Override
    public JMenuItem addToMenu(Action action, JMenu menu) throws MissingResourceException {
        JMenuItem item = menu.add(action);
        this.configureMenuItem(action, item);
        return item;
    }

    @Override
    public JMenu createMenu(String menuKey) throws MissingResourceException {
        JMenu menu = new JMenu();
        this.initMenu(menuKey, menu);
        return menu;
    }

    public JScrollMenu createScrollMenu(String menuKey) throws MissingResourceException {
        JScrollMenu menu = new JScrollMenu();
        this.initMenu(menuKey, menu);
        menu.setMaximumVisibleRows(this.getMaxVisibleMenuRowsCount());
        return menu;
    }

    private int getMaxVisibleMenuRowsCount() {
        JMenuItem menuItem = new JMenuItem("Test");
        JMenu menu = new JMenu();
        menu.add(menuItem);
        double maxVisibleRowsCount = (double)GUIUtils.getMinHeightOfAllScreens() / (double)menuItem.getPreferredSize().height - 3.0;
        return (int)maxVisibleRowsCount;
    }

    private void initMenu(String menuKey, JMenu menu) {
        String fullKey = "menu." + menuKey;
        menu.setText(this.getResourceString(fullKey, "title"));
        String mn = this.getResourceString(fullKey, "mnemonic");
        if (mn.length() >= 1) {
            menu.setMnemonic(mn.charAt(0));
        }
    }

    @Override
    public Action setupAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        boolean showColorIcons = Main.getApplication().getSquirrelPreferences().getShowColoriconsInToolbar();
        String key = this.getActionKey(action.getClass());
        String actionName = this.getActionName(action.getClass());
        action.putValue("Name", actionName);
        Object shortDescription = this.getResourceString(key, "tooltip");
        String acceleratorString = this.getAcceleratorString(action);
        if (null != acceleratorString && 0 < acceleratorString.trim().length()) {
            shortDescription = (String)shortDescription + "  (" + acceleratorString + ")";
        }
        action.putValue("ShortDescription", shortDescription);
        String accelerator = this.getAcceleratorString(action);
        if (null != accelerator) {
            action.putValue("SQuirreLAcceleratorString", accelerator);
        }
        ImageIcon icon = null;
        try {
            if (showColorIcons) {
                icon = this.getIcon(key, "rolloverimage");
                action.putValue("SmallIcon", icon);
            } else {
                icon = this.getIcon(key, "image");
                action.putValue("SmallIcon", icon);
            }
        }
        catch (MissingResourceException ex) {
            try {
                icon = this.getIcon(key, "image");
                action.putValue("SmallIcon", icon);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            icon = this.getIcon(key, "rolloverimage");
            action.putValue("squirrelRolloverIcon", icon);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            icon = this.getIcon(key, "disabledimage");
            action.putValue("squirrelDisabledIcon", icon);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return action;
    }

    public String getActionName(Class<? extends Action> actionClass) {
        return this.getResourceString(this.getActionKey(actionClass), "name");
    }

    private String getActionKey(Class<? extends Action> actionClass) {
        String actionClassName = actionClass.getName();
        return "action." + actionClassName;
    }

    @Override
    public ImageIcon getIcon(String keyName) {
        return this.getIcon(keyName, "image");
    }

    public URL getIconUrl(String keyName) {
        return this._getIconUrl(this.getResourceName(keyName, "image"));
    }

    @Override
    public ImageIcon getIcon(Class<?> objClass, String propName) {
        return this.getIcon(objClass.getName(), propName);
    }

    @Override
    public ImageIcon getIcon(String keyName, String propName) {
        String rsrcName = this.getResourceName(keyName, propName);
        ImageIcon icon = null;
        if (rsrcName != null && rsrcName.length() > 0) {
            icon = this._getIcon(rsrcName);
            if (icon == null) {
                s_log.error("can't load image: " + rsrcName);
            }
        } else if (s_log.isDebugEnabled()) {
            s_log.debug("No resource found for " + keyName + " : " + propName);
        }
        return icon;
    }

    private String getResourceName(String keyName, String propName) {
        if (keyName == null) {
            throw new IllegalArgumentException("keyName == null");
        }
        if (propName == null) {
            throw new IllegalArgumentException("propName == null");
        }
        String rsrcName = this.getResourceString(keyName, propName);
        return rsrcName;
    }

    @Override
    public String getString(String key) {
        return this._bundleHandler.getString(key);
    }

    @Override
    public void configureMenuItem(Action action, JMenuItem item) throws MissingResourceException {
        this.configureMenuItem(action, item, false);
    }

    public void configureMenuItem(Action action, JMenuItem item, boolean appendAccelereatorToToolTip) throws MissingResourceException {
        String mn;
        Utilities.checkNull("configureMenuItem", "action", action, "item", item);
        String fullKey = this.getFullMenuItemKey(action.getClass());
        if (action.getValue("MnemonicKey") == null && (mn = this.getResourceString(fullKey, "mnemonic")).length() > 0) {
            item.setMnemonic(mn.charAt(0));
        }
        item.setAccelerator(this._shortCutReader.getShortcutAsKeyStroke(fullKey, action));
        String toolTipText = this.getToolTipText(action, fullKey, appendAccelereatorToToolTip);
        item.setToolTipText(toolTipText);
    }

    private String getToolTipText(Action action, String fullKey, boolean withAccelerator) {
        Object toolTipText = (String)action.getValue("ShortDescription");
        if (null == toolTipText) {
            toolTipText = "";
        }
        if (withAccelerator) {
            toolTipText = (String)toolTipText + this.getAcceleratorString(action, fullKey, true);
        }
        return toolTipText;
    }

    protected ResourceBundleHandler getBundleHandler() {
        return this._bundleHandler;
    }

    private ImageIcon _getIcon(String iconResourceName) {
        URL url = this._getIconUrl(iconResourceName);
        if (url == null) {
            return null;
        }
        return Main.getApplication().getIconHandler().createImageIcon(url);
    }

    private URL _getIconUrl(String iconResourceName) {
        URL url;
        if (StringUtilities.isEmpty(iconResourceName, true)) {
            return null;
        }
        String imagePathName = this.getImagePathName(iconResourceName);
        if (null == this._classLoader) {
            url = this.getClass().getResource(imagePathName);
            if (null == url && imagePathName.startsWith("/")) {
                url = this.getClass().getResource(imagePathName.substring(1));
            } else if (null == url && !imagePathName.startsWith("/")) {
                url = this.getClass().getResource("/" + imagePathName);
            }
        } else {
            url = this._classLoader.getResource(imagePathName);
            if (null == url && imagePathName.startsWith("/")) {
                url = this._classLoader.getResource(imagePathName.substring(1));
            } else if (null == url && !imagePathName.startsWith("/")) {
                url = this._classLoader.getResource("/" + imagePathName);
            }
        }
        return url;
    }

    private String getResourceString(String keyName, String propName) throws MissingResourceException {
        return this._bundleHandler.getResourceString(keyName, propName);
    }

    private String getImagePathName(String iconName) {
        return this._bundleHandler.getImagePath() + iconName;
    }

    public ShortCutReader getShortCutReader() {
        return this._shortCutReader;
    }
}

