/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.NullMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang3.ArrayUtils;

public class MetaDataDataSet
implements IDataSet {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MetaDataDataSet.class);
    private static final Map<String, Object> s_ignoreMethods = new HashMap<String, Object>();
    private static final String[] s_hdgs;
    private DataSetDefinition _dsDef;
    private Iterator<Object[]> _rowsIter;
    private Object[] _row;
    private IMessageHandler _msgHandler;
    private List<Object[]> _data = new ArrayList<Object[]>();

    public MetaDataDataSet(DatabaseMetaData md) {
        this(md, null);
    }

    public MetaDataDataSet(DatabaseMetaData md, IMessageHandler msgHandler) {
        this._msgHandler = msgHandler != null ? msgHandler : NullMessageHandler.getInstance();
        this._dsDef = new DataSetDefinition(this.createColumnDefinitions());
        this.load(md);
    }

    @Override
    public final int getColumnCount() {
        return s_hdgs.length;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dsDef;
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) {
        this._row = this._rowsIter.hasNext() ? this._rowsIter.next() : null;
        return this._row != null;
    }

    @Override
    public synchronized Object get(int columnIndex) {
        return this._row[columnIndex];
    }

    private ColumnDisplayDefinition[] createColumnDefinitions() {
        int columnCount = this.getColumnCount();
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnDefs[i] = new ColumnDisplayDefinition(200, s_hdgs[i]);
        }
        return columnDefs;
    }

    private void load(DatabaseMetaData md) {
        Method[] methods = DatabaseMetaData.class.getMethods();
        Object[][] onTopLines = new Object[][]{{"getURL", null}, {"getDriverName", null}, {"getDatabaseProductName", null}, {"getDatabaseProductVersion", null}, {"getDriverVersion", null}, {"getUserName", null}, {"getDefaultTransactionIsolation", null}};
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE || s_ignoreMethods.containsKey(method.getName())) continue;
            Object[] generatedLine = this.generateLine(md, method);
            Object[] onTopLine = this.getMatchingOnTopLine(onTopLines, method.getName());
            if (null != onTopLine) {
                onTopLine[1] = generatedLine[1];
                continue;
            }
            this._data.add(generatedLine);
        }
        ArrayUtils.reverse((Object[])onTopLines);
        for (Object[] onTopLine : onTopLines) {
            this._data.add(0, onTopLine);
        }
        this._rowsIter = this._data.iterator();
    }

    private Object[] getMatchingOnTopLine(Object[][] onTopLines, String methodName) {
        for (Object[] onTopLine : onTopLines) {
            if (!onTopLine[0].equals(methodName)) continue;
            return onTopLine;
        }
        return null;
    }

    private Object[] generateLine(DatabaseMetaData md, Method getter) {
        Object[] line = new Object[2];
        line[0] = getter.getName();
        if (line[0].equals("getDefaultTransactionIsolation")) {
            try {
                line[1] = IStrings.UNSUPPORTED;
                int isol = md.getDefaultTransactionIsolation();
                switch (isol) {
                    case 0: {
                        line[1] = "TRANSACTION_NONE";
                        break;
                    }
                    case 2: {
                        line[1] = "TRANSACTION_READ_COMMITTED";
                        break;
                    }
                    case 1: {
                        line[1] = "TRANSACTION_READ_UNCOMMITTED";
                        break;
                    }
                    case 4: {
                        line[1] = "TRANSACTION_REPEATABLE_READ";
                        break;
                    }
                    case 8: {
                        line[1] = "TRANSACTION_SERIALIZABLE";
                        break;
                    }
                    default: {
                        line[1] = isol + "?";
                        break;
                    }
                }
            }
            catch (SQLException ex) {
                this._msgHandler.showMessage(ex, null);
            }
        } else if (line[0].equals("getClientInfoProperties")) {
            this._readClientInfoPropertiesFailSave(md, getter, line);
        } else {
            Object obj;
            line[1] = obj = this.executeGetter(md, getter);
        }
        return line;
    }

    private void _readClientInfoPropertiesFailSave(DatabaseMetaData md, Method getter, Object[] line) {
        block16: {
            try {
                Object obj = this.executeGetter(md, getter);
                if (obj instanceof ResultSet) {
                    try (ResultSet rs = (ResultSet)obj;){
                        int clientInfoColumnCount = 4;
                        if (rs.getMetaData() != null) {
                            clientInfoColumnCount = rs.getMetaData().getColumnCount();
                        }
                        StringBuilder tmp = new StringBuilder();
                        while (rs.next()) {
                            tmp.append(rs.getString(1));
                            if (clientInfoColumnCount > 1) {
                                if (rs.getMetaData() == null || rs.getMetaData().getColumnType(2) == 4) {
                                    tmp.append("\t").append(rs.getInt(2));
                                } else {
                                    tmp.append("\t").append(rs.getString(2));
                                }
                            }
                            if (clientInfoColumnCount > 2) {
                                tmp.append("\t").append(rs.getString(3));
                            }
                            if (clientInfoColumnCount > 3) {
                                tmp.append("\t").append(rs.getString(4));
                            }
                            tmp.append("\n");
                        }
                        line[1] = tmp.toString();
                        break block16;
                    }
                }
                line[1] = obj;
            }
            catch (Throwable ex) {
                this._msgHandler.showMessage(ex, null);
                line[1] = ex.toString();
            }
        }
    }

    protected Object executeGetter(Object bean, Method getter) {
        try {
            return getter.invoke(bean, (Object[])null);
        }
        catch (Throwable th) {
            return IStrings.UNSUPPORTED;
        }
    }

    static {
        s_ignoreMethods.put("getCatalogs", null);
        s_ignoreMethods.put("getConnection", null);
        s_ignoreMethods.put("getSchemas", null);
        s_ignoreMethods.put("getTableTypes", null);
        s_ignoreMethods.put("getTypeInfo", null);
        s_ignoreMethods.put("fail", null);
        s_ignoreMethods.put("hashCode", null);
        s_ignoreMethods.put("toString", null);
        s_ignoreMethods.put("getNumericFunctions", null);
        s_ignoreMethods.put("getStringFunctions", null);
        s_ignoreMethods.put("getSystemFunctions", null);
        s_ignoreMethods.put("getTimeDateFunctions", null);
        s_ignoreMethods.put("getSQLKeywords", null);
        s_hdgs = new String[]{IStrings.NAME_COLUMN, IStrings.VALUE_COLUMN};
    }

    private static interface IStrings {
        public static final String UNSUPPORTED = s_stringMgr.getString("MetaDataDataSet.unsupported");
        public static final String NAME_COLUMN = s_stringMgr.getString("MetaDataDataSet.propname");
        public static final String VALUE_COLUMN = s_stringMgr.getString("MetaDataDataSet.value");
    }
}

