/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.io.File;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.fw.sql.MetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class MetaDataDecoratorDataSet
extends MetaDataDataSet {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MetaDataDecoratorDataSet.class);
    boolean finishedLocalRows = false;
    Iterator<Object[]> iter = null;
    ArrayList<Object[]> data = new ArrayList();
    Object[] currentRow = null;

    public MetaDataDecoratorDataSet(DatabaseMetaData md, String driverClassName, String[] jarFileNames) {
        super(md, null);
        Object[] className = new Object[]{i18n.CLASS_NAME_LABEL, driverClassName};
        this.data.add(className);
        String[] classPathFiles = jarFileNames;
        StringBuffer classPathBuffer = new StringBuffer();
        if (classPathFiles.length == 0) {
            classPathBuffer.append(i18n.NO_JAR_FILES);
        } else {
            for (int i = 0; i < classPathFiles.length; ++i) {
                classPathBuffer.append(classPathFiles[i]);
                if (i + 1 >= classPathFiles.length) continue;
                classPathBuffer.append(File.pathSeparator);
            }
        }
        Object[] classPath = new Object[]{i18n.CLASS_PATH_LABEL, classPathBuffer.toString()};
        this.data.add(classPath);
        this.iter = this.data.iterator();
    }

    @Override
    public synchronized Object get(int columnIndex) {
        if (this.finishedLocalRows) {
            return super.get(columnIndex);
        }
        return this.currentRow[columnIndex];
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) {
        if (this.finishedLocalRows) {
            return super.next(msgHandler);
        }
        if (this.iter.hasNext()) {
            this.currentRow = this.iter.next();
            return true;
        }
        this.finishedLocalRows = true;
        return super.next(msgHandler);
    }

    private static interface i18n {
        public static final String CLASS_NAME_LABEL = s_stringMgr.getString("MetaDataDecoratorDataSet.classNameLabel");
        public static final String CLASS_PATH_LABEL = s_stringMgr.getString("MetaDataDecoratorDataSet.classPathLabel");
        public static final String NO_JAR_FILES = s_stringMgr.getString("MetaDataDecoratorDataSet.noJarFiles");
    }
}

