/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.ProcedureInfoOrigin;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ProcedureInfo
extends DatabaseObjectInfo
implements IProcedureInfo {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ProcedureInfo.class);
    private final int _procType;
    private ProcedureInfoOrigin _procedureInfoOrigin;
    private final String _remarks;

    public ProcedureInfo(String catalog, String schema, String simpleName, String remarks, int procType, SQLDatabaseMetaData md) {
        this(catalog, schema, simpleName, remarks, procType, null, md);
    }

    public ProcedureInfo(String catalog, String schema, String simpleName, String remarks, int procType, ProcedureInfoOrigin procedureInfoOrigin, SQLDatabaseMetaData md) {
        super(catalog, schema, simpleName, DatabaseObjectType.PROCEDURE, md);
        this._remarks = remarks;
        this._procType = procType;
        this._procedureInfoOrigin = procedureInfoOrigin;
    }

    @Override
    public int getProcedureType() {
        return this._procType;
    }

    @Override
    public String getRemarks() {
        return this._remarks;
    }

    @Override
    public String getProcedureTypeDescription() {
        switch (this._procType) {
            case 1: {
                return IStrings.DOESNT_RETURN;
            }
            case 2: {
                return IStrings.DOES_RETURN;
            }
            case 0: {
                return IStrings.MAY_RETURN;
            }
        }
        return IStrings.UNKNOWN;
    }

    public ProcedureInfoOrigin getProcedureInfoOrigin() {
        return this._procedureInfoOrigin;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof ProcedureInfo) {
            ProcedureInfo info = (ProcedureInfo)obj;
            if (info._remarks == null && this._remarks == null || info._remarks != null && this._remarks != null && info._remarks.equals(this._remarks)) {
                return info._procType == this._procType;
            }
        }
        return false;
    }

    private static interface IStrings {
        public static final String DATABASE = s_stringMgr.getString("ProcedureInfo.database");
        public static final String MAY_RETURN = s_stringMgr.getString("ProcedureInfo.mayreturn");
        public static final String DOESNT_RETURN = s_stringMgr.getString("ProcedureInfo.doesntreturn");
        public static final String DOES_RETURN = s_stringMgr.getString("ProcedureInfo.returns");
        public static final String UNKNOWN = s_stringMgr.getString("ProcedureInfo.unknown");
    }
}

