/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BlockMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetWrapper;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBlob;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeClob;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDate;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetReader {
    private static final ILogger s_log = LoggerController.createLogger(ResultSetReader.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultSetReader.class);
    private final ResultSetWrapper _rs;
    private final int[] _columnIndices;
    private final int _columnCount;
    private boolean _errorOccured = false;
    private final ResultSetMetaData _rsmd;
    private volatile boolean _stopExecution = false;
    private DialectType _dialectType = null;

    public ResultSetReader(ResultSet rs, DialectType dialectType) throws SQLException {
        this(rs, null, dialectType);
    }

    public ResultSetReader(ResultSetWrapper rs, DialectType dialectType) throws SQLException {
        this(rs, null, dialectType);
    }

    public ResultSetReader(ResultSet rs, int[] columnIndices, DialectType dialectType) throws SQLException {
        this(new ResultSetWrapper(rs), columnIndices, dialectType);
    }

    public ResultSetReader(ResultSetWrapper rs, int[] columnIndices, DialectType dialectType) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("ResultSet == null");
        }
        this._dialectType = dialectType;
        this._rs = rs;
        if (columnIndices != null && columnIndices.length == 0) {
            columnIndices = null;
        }
        this._columnIndices = columnIndices;
        this._rsmd = this._rs.getResultSet().getMetaData();
        this._columnCount = columnIndices != null ? columnIndices.length : this._rsmd.getColumnCount();
    }

    public Object[] readRow(BlockMode blockMode) throws SQLException {
        this._errorOccured = false;
        if (this._rs.next(blockMode)) {
            return this.doRead();
        }
        return null;
    }

    public Object[] readRow(ColumnDisplayDefinition[] colDefs, BlockMode blockMode, boolean limitRead) throws SQLException {
        this._errorOccured = false;
        if (this._rs.next(blockMode)) {
            return this.doContentTabRead(colDefs, limitRead);
        }
        return null;
    }

    public boolean getColumnErrorInPreviousRow() {
        return this._errorOccured;
    }

    private String safelyGetColumnTypeName(int idx) {
        String columnTypeName;
        block7: {
            block6: {
                columnTypeName = null;
                try {
                    columnTypeName = this._rsmd.getColumnTypeName(idx);
                }
                catch (SQLException e) {
                    if (!s_log.isInfoEnabled()) break block6;
                    s_log.info("doRead: ResultSetMetaData.getColumnTypeName(" + idx + ") threw an unexpected exception - " + e.getMessage());
                    s_log.info("Unable to determine column type name so any custom types provided by plugins will be unavailable.  This is a driver bug.");
                }
            }
            if (columnTypeName == null) {
                try {
                    columnTypeName = this._rsmd.getColumnClassName(idx);
                }
                catch (SQLException e) {
                    if (!s_log.isInfoEnabled()) break block7;
                    s_log.info("doRead: ResultSetMetaData.getColumnClassName(" + idx + ") threw an unexpected exception - " + e.getMessage());
                }
            }
        }
        if (columnTypeName == null) {
            columnTypeName = "Unavailable";
        }
        return columnTypeName;
    }

    private Object[] doRead() {
        Object[] row = new Object[this._columnCount];
        block19: for (int i = 0; i < this._columnCount && !this._stopExecution; ++i) {
            int idx = this._columnIndices != null ? this._columnIndices[i] : i + 1;
            try {
                int columnType = this._rsmd.getColumnType(idx);
                String columnTypeName = this.safelyGetColumnTypeName(idx);
                row[i] = CellComponentFactory.readResultWithPluginRegisteredDataType(this._rs.getResultSet(), columnType, columnTypeName, idx, this._dialectType);
                if (row[i] != null) continue;
                switch (columnType) {
                    case 0: {
                        row[i] = null;
                        break;
                    }
                    case -7: 
                    case 16: {
                        row[i] = this.readBoolean(idx);
                        break;
                    }
                    case 92: {
                        row[i] = this._rs.getResultSet().getTime(idx);
                        break;
                    }
                    case 91: {
                        row[i] = this.readDate(idx);
                        break;
                    }
                    case -102: 
                    case -101: 
                    case 93: {
                        row[i] = this._rs.getResultSet().getTimestamp(idx);
                        break;
                    }
                    case -5: {
                        row[i] = this.readBigint(idx);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        row[i] = this.readFloat(idx);
                        break;
                    }
                    case 2: 
                    case 3: {
                        row[i] = this.readNumeric(idx);
                        break;
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        row[i] = this.readInt(idx, columnTypeName);
                        break;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -8: 
                    case -1: 
                    case 1: 
                    case 12: {
                        row[i] = this._rs.getResultSet().getString(idx);
                        if (!this._rs.getResultSet().wasNull()) continue block19;
                        row[i] = null;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        row[i] = this._rs.getResultSet().getString(idx);
                        break;
                    }
                    case 2004: {
                        row[i] = DataTypeBlob.staticReadResultSet(this._rs.getResultSet(), idx);
                        break;
                    }
                    case 2005: 
                    case 2011: {
                        row[i] = DataTypeClob.staticReadResultSet(this._rs.getResultSet(), idx);
                        break;
                    }
                    case 2000: {
                        row[i] = this.readObject(idx);
                        break;
                    }
                    case 1111: {
                        row[i] = this.readOther(idx);
                        break;
                    }
                    default: {
                        if (row[i] != null) continue block19;
                        Integer colTypeInteger = columnType;
                        row[i] = s_stringMgr.getString("ResultSetReader.unknown", colTypeInteger);
                    }
                }
                continue;
            }
            catch (Throwable th) {
                if (this._stopExecution) continue;
                this._errorOccured = true;
                row[i] = s_stringMgr.getString("ResultSetReader.error");
                StringBuffer msg = new StringBuffer("Error reading column data");
                msg.append(", column index = ").append(idx);
                s_log.error(msg.toString(), th);
            }
        }
        return row;
    }

    private Object readNumeric(int columnIdx) throws SQLException {
        Object result = this._rs.getResultSet().getObject(columnIdx);
        if (result != null && !(result instanceof BigDecimal)) {
            if (result instanceof Number) {
                Number nbr = (Number)result;
                result = new BigDecimal(nbr.doubleValue());
            } else {
                result = new BigDecimal(result.toString());
            }
        }
        return result;
    }

    private Object readOther(int columnIdx) throws SQLException {
        return s_stringMgr.getString("ResultSetReader.other");
    }

    private Object readObject(int columnIdx) throws SQLException {
        Object result = this._rs.getResultSet().getObject(columnIdx);
        if (this._rs.getResultSet().wasNull()) {
            result = null;
        }
        return result;
    }

    private Object readInt(int columnIdx, String columnTypeName) throws SQLException {
        Object result = this._rs.getResultSet().getObject(columnIdx);
        if (this._rs.getResultSet().wasNull()) {
            return null;
        }
        if (result instanceof Long) {
            return result;
        }
        if ("INTEGER UNSIGNED".equalsIgnoreCase(columnTypeName)) {
            return Long.valueOf(result.toString());
        }
        if (result instanceof Integer) {
            return result;
        }
        if (result instanceof Number) {
            Number resultNumber = (Number)result;
            int intValue = resultNumber.intValue();
            return intValue;
        }
        return Integer.valueOf(result.toString());
    }

    private Object readFloat(int columnIdx) throws SQLException {
        Object result = this._rs.getResultSet().getObject(columnIdx);
        if (result != null && !(result instanceof Double)) {
            if (result instanceof Number) {
                Number nbr = (Number)result;
                result = nbr.doubleValue();
            } else {
                result = Double.valueOf(result.toString());
            }
        }
        return result;
    }

    private Object readDate(int columnIdx) throws SQLException {
        Object result = null;
        result = DataTypeDate.getReadDateAsTimestamp() ? this._rs.getResultSet().getTimestamp(columnIdx) : DataTypeDate.staticReadResultSet(this._rs.getResultSet(), columnIdx, false);
        return result;
    }

    private Object readBigint(int columnIdx) throws SQLException {
        Object result = this._rs.getResultSet().getObject(columnIdx);
        if (result != null && !(result instanceof Long)) {
            result = result instanceof Number ? Long.valueOf(((Number)result).longValue()) : Long.valueOf(result.toString());
        }
        return result;
    }

    private Object readBoolean(int columnIdx) throws SQLException {
        Object result = null;
        result = this._rs.getResultSet().getObject(columnIdx);
        if (result != null && !(result instanceof Boolean)) {
            result = result instanceof Number ? (((Number)result).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE) : Boolean.valueOf(result.toString());
        }
        return result;
    }

    private Object[] doContentTabRead(ColumnDisplayDefinition[] colDefs, boolean limitDataRead) {
        Object[] row = new Object[this._columnCount];
        for (int i = 0; i < this._columnCount && !this._stopExecution; ++i) {
            int idx = this._columnIndices != null ? this._columnIndices[i] : i + 1;
            try {
                int columnType = this._rsmd.getColumnType(idx);
                switch (columnType) {
                    case 0: {
                        row[i] = null;
                        break;
                    }
                    default: {
                        row[i] = CellComponentFactory.readResultSet(colDefs[i], this._rs.getResultSet(), idx, limitDataRead);
                        break;
                    }
                }
                continue;
            }
            catch (Throwable th) {
                this._errorOccured = true;
                row[i] = s_stringMgr.getString("ResultSetReader.error");
                if (this._stopExecution) continue;
                StringBuffer msg = new StringBuffer("Error reading column data");
                msg.append(", column index = ").append(idx);
                s_log.error(msg.toString(), th);
            }
        }
        return row;
    }

    public void setStopExecution(boolean _stopExecution) {
        this._stopExecution = _stopExecution;
    }

    public boolean isStopExecution() {
        return this._stopExecution;
    }

    public boolean isAllResultsRead() {
        return this._rs.isAllResultsRead();
    }

    public boolean areAllPossibleResultsOfSQLRead() {
        return this._rs.areAllPossibleResultsOfSQLRead();
    }

    public boolean isResultLimitedByMaxRowsCount() {
        return this._rs.isResultLimitedByMaxRowsCount();
    }

    public void closeStatementAndResultSet() {
        this._rs.closeStatementAndResultSet();
    }
}

