/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaDataFactory;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.TimeOutUtil;
import net.sourceforge.squirrel_sql.fw.util.PropertyChangeReporter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public class SQLConnection
implements ISQLConnection {
    private ISQLDriver _sqlDriver;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLConnection.class);
    private static final ILogger s_log = LoggerController.createLogger(SQLConnection.class);
    private Connection _conn;
    private final SQLDriverPropertyCollection _connProps;
    private boolean _autoCommitOnClose = false;
    private Date _timeOpened;
    private Date _timeClosed;
    private transient PropertyChangeReporter _propChgReporter;
    private SQLDatabaseMetaData metaData = null;

    public SQLConnection(Connection conn, SQLDriverPropertyCollection connProps, ISQLDriver sqlDriver) {
        this._sqlDriver = sqlDriver;
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        this._conn = conn;
        this._connProps = connProps;
        this._timeOpened = Calendar.getInstance().getTime();
        try {
            HibernateDialect dialect = DialectFactory.getDialect(this._conn.getMetaData().getDatabaseProductName());
            if (null == dialect) {
                this.metaData = new SQLDatabaseMetaData(this);
            } else {
                DialectType type = dialect.getDialectType();
                this.metaData = SQLDatabaseMetaDataFactory.fetchMeta(type, this);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            TimeOutUtil.invokeWithTimeout(() -> this._closeIntern());
        }
        catch (Throwable e) {
            if (Utilities.getDeepestThrowable(e) instanceof TimeoutException) {
                String message = "The database connection took longer than " + TimeOutUtil.getDefaultOrConfiguredTimeoutMillis() + " millis to close. Maybe closing will succeed later but SQuirreL stops waiting to stay responsive for user interaction.";
                s_log.error(message, e);
            } else {
                s_log.error("Error while closing connection", e);
            }
        }
        finally {
            this._conn = null;
        }
    }

    private void _closeIntern() {
        block8: {
            try {
                SQLException savedEx = null;
                if (this._conn == null) break block8;
                s_log.debug("Closing connection");
                try {
                    if (!this._conn.getAutoCommit()) {
                        if (this._autoCommitOnClose) {
                            this._conn.commit();
                        } else {
                            this._conn.rollback();
                        }
                    }
                }
                catch (SQLException ex) {
                    savedEx = ex;
                }
                this._conn.close();
                this._conn = null;
                this._timeClosed = Calendar.getInstance().getTime();
                if (savedEx != null) {
                    s_log.debug("Connection close failed", savedEx);
                    throw savedEx;
                }
                s_log.debug("Connection closed successfully");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        this.validateConnection();
        this._conn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.validateConnection();
        this._conn.rollback();
    }

    @Override
    public SQLDriverPropertyCollection getConnectionProperties() {
        return this._connProps;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.validateConnection();
        return this._conn.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean value) throws SQLException {
        this.validateConnection();
        Connection conn = this.getConnection();
        boolean oldValue = conn.getAutoCommit();
        if (oldValue != value) {
            this._conn.setAutoCommit(value);
            this.getPropertyChangeReporter().firePropertyChange("autocommit", oldValue, value);
        }
    }

    @Override
    public boolean getCommitOnClose() {
        return this._autoCommitOnClose;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.validateConnection();
        return this._conn.getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(int value) throws SQLException {
        this.validateConnection();
        this._conn.setTransactionIsolation(value);
    }

    @Override
    public void setCommitOnClose(boolean value) {
        this._autoCommitOnClose = value;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.validateConnection();
        return this._conn.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateConnection();
        return this._conn.prepareStatement(sql);
    }

    @Override
    public Date getTimeOpened() {
        return this._timeOpened;
    }

    @Override
    public Date getTimeClosed() {
        return this._timeClosed;
    }

    @Override
    public SQLDatabaseMetaData getSQLMetaData() {
        return this.metaData;
    }

    @Override
    public Connection getConnection() {
        return this._conn;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.validateConnection();
        return this.getConnection().getCatalog();
    }

    @Override
    public String getSchema() throws SQLException {
        this.validateConnection();
        return this.getConnection().getSchema();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.validateConnection();
        this.getConnection().setSchema(schema);
    }

    @Override
    public void setCatalog(String catalogName) throws SQLException {
        this.validateConnection();
        Connection conn = this.getConnection();
        String oldValue = conn.getCatalog();
        DialectType dialectType = DialectFactory.getDialectType(this.metaData);
        if (!StringUtils.equals((CharSequence)oldValue, (CharSequence)catalogName)) {
            this.setDbSpecificCatalog(dialectType, catalogName);
            this.getPropertyChangeReporter().firePropertyChange("catalog", oldValue, catalogName);
        }
    }

    private void setDbSpecificCatalog(DialectType dialectType, String catalogName) throws SQLException {
        switch (dialectType) {
            case MSSQL: {
                this.setMSSQLServerCatalog(catalogName);
                break;
            }
            case INFORMIX: {
                this.setInformixCatalog(catalogName);
                break;
            }
            default: {
                this.setGenericDbCatalog(catalogName);
            }
        }
    }

    private void setGenericDbCatalog(String catalogName) throws SQLException {
        Connection conn = this.getConnection();
        conn.setCatalog(catalogName);
    }

    private void setMSSQLServerCatalog(String catalogName) throws SQLException {
        Connection conn = this.getConnection();
        try {
            conn.setCatalog(catalogName);
            return;
        }
        catch (SQLException e) {
            s_log.error("Connection.setCatalog yielded an exception for catalog (" + catalogName + ") :" + e.getMessage() + " - will try quoting the catalog next.", e);
            conn.setCatalog(this.quote(catalogName));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInformixCatalog(String catalogName) throws SQLException {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String sql = "DATABASE " + catalogName;
        try {
            stmt = conn.createStatement();
            stmt.execute(sql);
        }
        catch (SQLException e) {
            s_log.error("setInformixCatalog: failed to change database with the database SQL directive: " + sql);
        }
        finally {
            SQLUtilities.closeStatement(stmt);
        }
        conn.setCatalog(catalogName);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.validateConnection();
        return this._conn.getWarnings();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.getPropertyChangeReporter().addPropertyChangeListener(listener);
        } else {
            s_log.debug("Attempted to add a null PropertyChangeListener");
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.getPropertyChangeReporter().removePropertyChangeListener(listener);
        } else {
            s_log.debug("Attempted to remove a null PropertyChangeListener");
        }
    }

    protected void validateConnection() throws SQLException {
        if (this._conn == null) {
            throw new SQLException(s_stringMgr.getString("SQLConnection.noConn"));
        }
    }

    private synchronized PropertyChangeReporter getPropertyChangeReporter() {
        if (this._propChgReporter == null) {
            this._propChgReporter = new PropertyChangeReporter(this);
        }
        return this._propChgReporter;
    }

    private String quote(String str) {
        if (str.startsWith("\"")) {
            return str;
        }
        String identifierQuoteString = "";
        try {
            identifierQuoteString = this.getSQLMetaData().getIdentifierQuoteString();
        }
        catch (SQLException ex) {
            s_log.debug("DBMS doesn't supportDatabasemetaData.getIdentifierQuoteString", ex);
        }
        if (identifierQuoteString != null && !identifierQuoteString.equals(" ")) {
            return identifierQuoteString + str + identifierQuoteString;
        }
        return str;
    }

    @Override
    public ISQLDriver getSQLDriver() {
        return this._sqlDriver;
    }
}

