/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.ISessionProperties;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLConnectionState {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLConnectionState.class);
    private static final ILogger s_log = LoggerController.createLogger(SQLConnectionState.class);
    private Integer _transIsolation;
    private String _catalog;
    private boolean _autoCommit;
    private SQLDriverPropertyCollection _connProps;

    public void saveState(ISQLConnection con, ISessionProperties sessionProperties, IMessageHandler msgHandler, String selectedCatalogFromCatalogsComboBox) {
        String msg;
        try {
            this._transIsolation = null;
            if (null != con) {
                this._transIsolation = Utilities.callWithTimeout(() -> con.getTransactionIsolation());
            }
        }
        catch (Exception ex) {
            msg = s_stringMgr.getString("SQLConnectionState.errorSavingIsolationState");
            s_log.error(msg, ex);
            msgHandler.showErrorMessage(msg, ex);
        }
        try {
            this._catalog = selectedCatalogFromCatalogsComboBox;
            if (null != con) {
                this._catalog = Utilities.callWithTimeout(() -> con.getCatalog());
            }
        }
        catch (Exception ex) {
            msg = s_stringMgr.getString("SQLConnectionState.errorSavingCatalog");
            s_log.error(msg, ex);
            msgHandler.showErrorMessage(msg, ex);
        }
        try {
            this._autoCommit = sessionProperties.getAutoCommit();
            if (null != con) {
                this._autoCommit = Utilities.callWithTimeout(() -> con.getAutoCommit());
            }
        }
        catch (Exception ex) {
            msg = s_stringMgr.getString("SQLConnectionState.errorSavingAutoCommit");
            s_log.error(msg, ex);
            msgHandler.showErrorMessage(msg, ex);
        }
        try {
            this._connProps = null;
            if (null != con) {
                this._connProps = Utilities.callWithTimeout(() -> con.getConnectionProperties());
            }
        }
        catch (Exception e) {
            s_log.error(e);
            msgHandler.showErrorMessage(e);
        }
    }

    public void restoreState(ISQLConnection conn, IMessageHandler msgHandler) {
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        if (this._transIsolation != null) {
            try {
                conn.setTransactionIsolation(this._transIsolation);
            }
            catch (Exception ex) {
                s_log.error("Error restoring transaction isolation", ex);
                msgHandler.showErrorMessage(ex, null);
            }
        }
        if (this._catalog != null) {
            try {
                conn.setCatalog(this._catalog);
            }
            catch (Exception ex) {
                s_log.error("Error restoring current catalog", ex);
                msgHandler.showErrorMessage(ex, null);
            }
        }
        try {
            conn.setAutoCommit(this._autoCommit);
        }
        catch (Exception ex) {
            s_log.error("Error restoring autocommit", ex);
            msgHandler.showErrorMessage(ex, null);
        }
    }

    public SQLDriverPropertyCollection getConnectionProperties() {
        return this._connProps;
    }

    public boolean getAutoCommit() {
        return this._autoCommit;
    }
}

