/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.SquirrelURLClassLoader;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLDriverClassLoader
extends SquirrelURLClassLoader {
    private static final ILogger s_log = LoggerController.createLogger(SQLDriverClassLoader.class);

    public SQLDriverClassLoader(ISQLDriver sqlDriver) {
        super(SQLDriverClassLoader.createURLs(sqlDriver.getName(), sqlDriver.getJarFileNames()));
    }

    public SQLDriverClassLoader(URL[] urls) {
        super(urls);
    }

    public SQLDriverClassLoader(URL url) {
        super(url);
    }

    public Class<?>[] getDriverClasses(ILogger logger) {
        Class[] classes = this.getAssignableClasses(Driver.class, logger);
        ArrayList<Class> list = new ArrayList<Class>();
        for (int i = 0; i < classes.length; ++i) {
            Class clazz = classes[i];
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            list.add(clazz);
        }
        return list.toArray(new Class[list.size()]);
    }

    private static URL[] createURLs(String driverName, String[] fileNames) {
        try {
            if (fileNames == null) {
                fileNames = new String[]{};
            }
            URL[] urls = new URL[fileNames.length];
            for (int i = 0; i < fileNames.length; ++i) {
                File f = new File(fileNames[i]);
                if (!f.exists()) {
                    s_log.info("For driver '" + driverName + "', the JVM says file doesn't exist: " + fileNames[i]);
                }
                if (f.isDirectory()) {
                    s_log.info("For driver '" + driverName + "', the JVM says the file is a directory: " + fileNames[i]);
                }
                if (!f.canRead()) {
                    s_log.info("For driver '" + driverName + "', the JVM says the file can't be read: " + fileNames[i]);
                }
                urls[i] = f.toURI().toURL();
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (null != loadedClass) {
            this.checkResolveClass(resolve, loadedClass);
            return loadedClass;
        }
        try {
            loadedClass = this.findClass(name);
            this.checkResolveClass(resolve, loadedClass);
            return loadedClass;
        }
        catch (ClassNotFoundException e) {
            try {
                loadedClass = super.loadClass(name, resolve);
                this.checkResolveClass(resolve, loadedClass);
                return loadedClass;
            }
            catch (ClassNotFoundException e2) {
                if (null != SQLDriverClassLoader.getSystemClassLoader()) {
                    loadedClass = SQLDriverClassLoader.getSystemClassLoader().loadClass(name);
                    this.checkResolveClass(resolve, loadedClass);
                    return loadedClass;
                }
                throw e2;
            }
        }
    }

    private void checkResolveClass(boolean resolve, Class<?> loadedClass) {
        if (resolve) {
            this.resolveClass(loadedClass);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentRes;
        Enumeration<URL> thisRes;
        final LinkedList<URL> allRes = new LinkedList<URL>();
        Enumeration<URL> sysResources = SQLDriverClassLoader.getSystemClassLoader().getResources(name);
        if (sysResources != null) {
            while (sysResources.hasMoreElements()) {
                allRes.add(sysResources.nextElement());
            }
        }
        if ((thisRes = this.findResources(name)) != null) {
            while (thisRes.hasMoreElements()) {
                allRes.add(thisRes.nextElement());
            }
        }
        if ((parentRes = super.findResources(name)) != null) {
            while (parentRes.hasMoreElements()) {
                allRes.add(parentRes.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> it;
            {
                this.it = allRes.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    public URL getResource(String name) {
        URL res = this.findResource(name);
        if (res != null) {
            return res;
        }
        if (SQLDriverClassLoader.getSystemClassLoader() != null && (res = SQLDriverClassLoader.getSystemClassLoader().getResource(name)) != null) {
            return res;
        }
        return super.getResource(name);
    }
}

