/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Driver;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.session.action.reconnect.ReconnectInfo;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnector;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverClassLoader;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLDriverManager {
    private static final ILogger s_log = LoggerController.createLogger(SQLDriverManager.class);
    private Map<IIdentifier, Driver> _driverInfo = new HashMap<IIdentifier, Driver>();
    private Map<IIdentifier, SQLDriverClassLoader> _classLoaders = new HashMap<IIdentifier, SQLDriverClassLoader>();
    private MyDriverListener _myDriverListener = new MyDriverListener();

    public synchronized void registerSQLDriver(ISQLDriver sqlDriver) throws ClassNotFoundException {
        try {
            this.unregisterSQLDriver(sqlDriver);
            sqlDriver.addPropertyChangeListener(this._myDriverListener);
            SQLDriverClassLoader loader = new SQLDriverClassLoader(sqlDriver);
            Driver driver = (Driver)Class.forName(sqlDriver.getDriverClassName(), false, loader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this._driverInfo.put(sqlDriver.getIdentifier(), driver);
            this._classLoaders.put(sqlDriver.getIdentifier(), loader);
            sqlDriver.setJDBCDriverClassLoaded(true);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public synchronized void unregisterSQLDriver(ISQLDriver sqlDriver) {
        sqlDriver.setJDBCDriverClassLoaded(false);
        sqlDriver.removePropertyChangeListener(this._myDriverListener);
        this._driverInfo.remove(sqlDriver.getIdentifier());
        this._classLoaders.remove(sqlDriver.getIdentifier());
    }

    public ISQLConnection getConnection(ISQLDriver sqlDriver, SQLAlias alias, String user, String pw) {
        return this.getConnection(sqlDriver, alias, user, pw, null);
    }

    public SQLConnection getConnection(ISQLDriver sqlDriver, SQLAlias alias, String user, String pw, SQLDriverPropertyCollection props) {
        return this.getConnection(sqlDriver, alias, user, pw, props, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLConnection getConnection(ISQLDriver sqlDriver, SQLAlias alias, String user, String pw, SQLDriverPropertyCollection props, ReconnectInfo reconnectInfo) {
        Driver driver;
        SQLDriverManager sQLDriverManager = this;
        synchronized (sQLDriverManager) {
            driver = this._driverInfo.get(sqlDriver.getIdentifier());
        }
        return SQLConnector.getSqlConnection(sqlDriver, alias, user, pw, props, reconnectInfo, driver);
    }

    public Driver getJDBCDriver(IIdentifier id) {
        if (id == null) {
            throw new IllegalArgumentException("IIdentifier == null");
        }
        return this._driverInfo.get(id);
    }

    public SQLDriverClassLoader getSQLDriverClassLoader(ISQLDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("SQLDriverClassLoader == null");
        }
        return this._classLoaders.get(driver.getIdentifier());
    }

    private final class MyDriverListener
    implements PropertyChangeListener {
        private MyDriverListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || propName.equals("driverClassName") || propName.equals("jarFileNames")) {
                Object obj = evt.getSource();
                if (obj instanceof ISQLDriver) {
                    ISQLDriver driver = (ISQLDriver)obj;
                    SQLDriverManager.this.unregisterSQLDriver(driver);
                    try {
                        SQLDriverManager.this.registerSQLDriver(driver);
                    }
                    catch (ClassNotFoundException ex) {
                        String[] jars = driver.getJarFileNames();
                        Object jarFileList = "<empty list>";
                        if (jars != null) {
                            jarFileList = "[ " + StringUtilities.join(jars, ", ") + " ]";
                        }
                        s_log.error("Unable to find Driver Class " + driver.getDriverClassName() + " for JDBC driver " + driver.getName() + "; jar filenames = " + (String)jarFileList);
                    }
                    catch (Exception ex) {
                        s_log.error("Unable to create instance of Class " + driver.getDriverClassName() + " for JDBC driver " + driver.getName(), ex);
                    }
                } else {
                    s_log.error("SqlDriverManager.MyDriverListener is listening to a non-ISQLDriver");
                }
            }
        }
    }
}

