/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.io.Serializable;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasVersioner;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverProperty;
import org.apache.commons.lang3.StringUtils;

public class SQLDriverPropertyCollection
implements Serializable {
    private final Map<String, SQLDriverProperty> _objectsIndexMap = new TreeMap<String, SQLDriverProperty>();
    private final List<SQLDriverProperty> _objectsList = new ArrayList<SQLDriverProperty>();
    private SQLAliasVersioner _versioner = new SQLAliasVersioner();

    public void clear() {
        this._objectsIndexMap.clear();
        this._objectsList.clear();
    }

    public int size() {
        return this._objectsList.size();
    }

    public void applyTo(Properties props) {
        int limit = this.size();
        for (int i = 0; i < limit; ++i) {
            String value;
            SQLDriverProperty sdp = this.getDriverProperty(i);
            if (!sdp.isSpecified() || (value = sdp.getValue()) == null) continue;
            props.put(sdp.getName(), value);
        }
    }

    public SQLDriverProperty[] getDriverProperties() {
        SQLDriverProperty[] ar = new SQLDriverProperty[this._objectsList.size()];
        return this._objectsList.toArray(ar);
    }

    public SQLDriverProperty getDriverProperty(int idx) {
        return this._objectsList.get(idx);
    }

    public SQLDriverProperty getDriverPropertyByName(String name) {
        return this._objectsList.stream().filter(p -> StringUtils.equals((CharSequence)p.getName(), (CharSequence)name)).findFirst().orElse(null);
    }

    public void setDriverProperties(SQLDriverProperty[] values) {
        this._objectsIndexMap.clear();
        this._objectsList.clear();
        for (int i = 0; i < values.length; ++i) {
            this._objectsList.add(values[i]);
            this._objectsIndexMap.put(values[i].getName(), values[i]);
        }
    }

    public void addDriverProperty(SQLDriverProperty value) {
        this._objectsList.add(value);
        this._objectsIndexMap.put(value.getName(), value);
    }

    public void removeDriverProperty(String name) {
        SQLDriverProperty prop = this._objectsIndexMap.remove(name);
        this._objectsList.remove(prop);
    }

    public void setDriverProperty(int idx, SQLDriverProperty value) {
        this._objectsList.add(idx, value);
        this._objectsIndexMap.put(value.getName(), value);
    }

    public void applyDriverPropertyInfo(DriverPropertyInfo[] infoAr) {
        if (infoAr == null || infoAr.length == 0) {
            infoAr = new DriverPropertyInfo[]{new DriverPropertyInfo("remarksReporting", "true")};
            infoAr[0].required = false;
            infoAr[0].description = "Set to true in order to table/column comments";
        }
        for (int i = 0; i < infoAr.length; ++i) {
            SQLDriverProperty sdp = this._objectsIndexMap.get(infoAr[i].name);
            if (sdp == null) {
                sdp = new SQLDriverProperty(infoAr[i]);
                this._objectsIndexMap.put(sdp.getName(), sdp);
                this._objectsList.add(sdp);
            }
            sdp.setDriverPropertyInfo(infoAr[i]);
        }
    }

    public void acceptAliasVersioner(SQLAliasVersioner versioner) {
        this._versioner = versioner;
    }

    public SQLAliasVersioner getVersioner() {
        return this._versioner;
    }

    public static interface IPropertyNames {
        public static final String DRIVER_PROPERTIES = "driverProperties";
    }
}

