/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql.commentandliteral;

import net.sourceforge.squirrel_sql.fw.sql.commentandliteral.NextPositionAction;

public class SQLCommentAndLiteralHandler {
    private static final String MULTI_LINE_COMMENT_END = "*/";
    private static final String MULTI_LINE_COMMENT_BEGIN = "/*";
    private String _script;
    private String _lineCommentBegin;
    private boolean _removeMultiLineComment;
    private boolean _removeLineComment;
    private boolean _isInLiteral = false;
    private boolean _isInMultiLineComment = false;
    private boolean _isInLineComment = false;
    private int _literalSepCount = 0;

    public SQLCommentAndLiteralHandler(String script, String lineCommentBegin, boolean removeMultiLineComment, boolean removeLineComment) {
        this._script = script;
        this._lineCommentBegin = lineCommentBegin;
        this._removeMultiLineComment = removeMultiLineComment;
        this._removeLineComment = removeLineComment;
    }

    public NextPositionAction nextPosition(int posInScript) {
        if (this._script.length() <= posInScript) {
            throw new IllegalStateException("Script position out of bounds: " + posInScript + " >= " + this._script.length());
        }
        char c = this._script.charAt(posInScript);
        if (!this._isInLiteral) {
            if (this._isInLineComment && this._script.startsWith("\n", posInScript - "\n".length())) {
                this._isInLineComment = false;
            }
            if (this._isInMultiLineComment && this._script.startsWith(MULTI_LINE_COMMENT_END, posInScript - MULTI_LINE_COMMENT_END.length()) && this.isInBeginningOfMultiLineComment(posInScript)) {
                this._isInMultiLineComment = false;
            }
            if (!this._isInLineComment && !this._isInMultiLineComment) {
                this._isInMultiLineComment = this._script.startsWith(MULTI_LINE_COMMENT_BEGIN, posInScript);
                this._isInLineComment = this._script.startsWith(this._lineCommentBegin, posInScript);
            }
            if (this._isInMultiLineComment && this._removeMultiLineComment || this._isInLineComment && this._removeLineComment) {
                return NextPositionAction.SKIP;
            }
        }
        if ('\'' == c) {
            if (!this._isInLiteral) {
                this._isInLiteral = true;
            } else {
                ++this._literalSepCount;
            }
        } else {
            if (0 != this._literalSepCount % 2) {
                this._isInLiteral = false;
            }
            this._literalSepCount = 0;
        }
        return NextPositionAction.APPEND;
    }

    private boolean isInBeginningOfMultiLineComment(int posInScript) {
        int backwardCount = MULTI_LINE_COMMENT_BEGIN.length() + 1;
        return posInScript >= backwardCount && false == this._script.startsWith(MULTI_LINE_COMMENT_BEGIN, posInScript - backwardCount);
    }

    public boolean isInLiteral() {
        return this._isInLiteral;
    }

    public boolean isInMultiLineComment() {
        return this._isInMultiLineComment;
    }

    public boolean isInLineComment() {
        return this._isInLineComment;
    }
}

