/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql.databasemetadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BlockMode;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.ProcedureInfoOrigin;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaDataUtil;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ProcedureAndFunctionMetaData {
    private static final ILogger s_log = LoggerController.createLogger(SQLDatabaseMetaData.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<IProcedureInfo> getProcedureInfos(String catalog, String schemaPattern, String procedureNamePattern, ProgressCallBack progressCallBack, SQLDatabaseMetaData md) throws SQLException {
        ArrayList<IProcedureInfo> list = new ArrayList<IProcedureInfo>();
        ResultSet rs = md.getJDBCMetaData().getProcedures(catalog, schemaPattern, procedureNamePattern);
        if (rs == null) {
            return list;
        }
        int count = 0;
        try {
            Object[] row;
            int[] cols = new int[]{1, 2, 3, 7, 8};
            DialectType dialectType = DialectFactory.getDialectType(md);
            ResultSetReader rdr = new ResultSetReader(rs, cols, dialectType);
            while ((row = rdr.readRow(BlockMode.INDIFFERENT)) != null) {
                if (row[4] == null || !(row[4] instanceof Number)) {
                    if (row[4] != null) {
                        s_log.warn("Error reading procedure meta data for column 8 (PROCEDURE_TYPE): According to the API of java.sql.DatabaseMetaData.getProcedures(...) the type should be int but is " + row[4].getClass().getName() + " with value " + row[4]);
                    }
                    row[4] = 0;
                }
                int type = ((Number)row[4]).intValue();
                ProcedureInfo pi = new ProcedureInfo(SQLDatabaseMetaDataUtil.getAsString(row[0]), SQLDatabaseMetaDataUtil.getAsString(row[1]), SQLDatabaseMetaDataUtil.getAsString(row[2]), SQLDatabaseMetaDataUtil.getAsString(row[3]), type, ProcedureInfoOrigin.GET_PROCEDURES, md);
                list.add(pi);
                if (null == progressCallBack || 0 != count++ % 200) continue;
                progressCallBack.currentlyLoading(pi.getSimpleName());
            }
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
        return list;
    }

    static List<IProcedureInfo> getFunctionInfos(String catalog, String schemaPattern, String funtionNamePattern, ProgressCallBack progressCallBack, SQLDatabaseMetaData md) throws SQLException {
        try {
            return ProcedureAndFunctionMetaData._getFunctionInfos(catalog, schemaPattern, funtionNamePattern, progressCallBack, md);
        }
        catch (Exception e) {
            s_log.error(e);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<IProcedureInfo> _getFunctionInfos(String catalog, String schemaPattern, String funtionNamePattern, ProgressCallBack progressCallBack, SQLDatabaseMetaData md) throws SQLException {
        ArrayList<IProcedureInfo> list = new ArrayList<IProcedureInfo>();
        ResultSet rs = md.getJDBCMetaData().getFunctions(catalog, schemaPattern, funtionNamePattern);
        if (rs == null) {
            return list;
        }
        int count = 0;
        try {
            Object[] row;
            int[] cols = new int[]{1, 2, 3, 4, 5};
            DialectType dialectType = DialectFactory.getDialectType(md);
            ResultSetReader rdr = new ResultSetReader(rs, cols, dialectType);
            while ((row = rdr.readRow(BlockMode.INDIFFERENT)) != null) {
                if (row[4] == null || !(row[4] instanceof Number)) {
                    if (row[4] != null) {
                        s_log.warn("Error reading procedure meta data for column 8 (PROCEDURE_TYPE): According to the API of java.sql.DatabaseMetaData.getProcedures(...) the type should be int but is " + row[4].getClass().getName() + " with value " + row[4]);
                    }
                    row[4] = 0;
                }
                int type = ((Number)row[4]).intValue();
                ProcedureInfo pi = new ProcedureInfo(SQLDatabaseMetaDataUtil.getAsString(row[0]), SQLDatabaseMetaDataUtil.getAsString(row[1]), SQLDatabaseMetaDataUtil.getAsString(row[2]), SQLDatabaseMetaDataUtil.getAsString(row[3]), type, ProcedureInfoOrigin.GET_FUNCTIONS, md);
                list.add(pi);
                if (null == progressCallBack || 0 != count++ % 200) continue;
                progressCallBack.currentlyLoading(pi.getSimpleName());
            }
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
        return list;
    }
}

