/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql.querytokenizer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.SQLScriptServices;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.sql.commentandliteral.NextPositionAction;
import net.sourceforge.squirrel_sql.fw.sql.commentandliteral.SQLCommentAndLiteralHandler;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.ITokenizerFactory;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryHolder;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.TokenizerSessPropsInteractions;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class QueryTokenizer
implements IQueryTokenizer {
    protected ArrayList<QueryHolder> _queries = new ArrayList();
    protected Iterator<QueryHolder> _queryIterator;
    protected String _querySep = null;
    protected String _lineCommentBegin = null;
    protected boolean _removeMultiLineComment = true;
    protected boolean _removeLineComment = true;
    protected ITokenizerFactory _tokenizerFactory = null;
    private static final ILogger s_log = LoggerController.createLogger(QueryTokenizer.class);

    public QueryTokenizer(String querySep, String lineCommentBegin, boolean removeMultiLineComment, boolean removeLineComment) {
        this._querySep = querySep;
        this._lineCommentBegin = lineCommentBegin;
        this._removeMultiLineComment = removeMultiLineComment;
        this._removeLineComment = removeLineComment;
        this.setFactory();
    }

    public QueryTokenizer(IQueryTokenizerPreferenceBean prefs) {
        this(prefs.getStatementSeparator(), prefs.getLineComment(), prefs.isRemoveMultiLineComments(), prefs.isRemoveLineComments());
    }

    protected void setFactory() {
        this._tokenizerFactory = () -> new QueryTokenizer(this._querySep, this._lineCommentBegin, this._removeMultiLineComment, this._removeLineComment);
    }

    private int getLenOfQuerySepIfAtLastCharOfQuerySep(String sql, int i, String querySep, boolean inLiteral) {
        if (inLiteral) {
            return -1;
        }
        char c = sql.charAt(i);
        if (1 == querySep.length() && c == querySep.charAt(0)) {
            return 1;
        }
        int fromIndex = i - querySep.length();
        if (0 > fromIndex) {
            return -1;
        }
        int querySepIndex = sql.indexOf(querySep, fromIndex);
        if (0 > querySepIndex) {
            return -1;
        }
        if (Character.isWhitespace(c)) {
            if (querySepIndex + querySep.length() == i) {
                if (0 == querySepIndex) {
                    return querySep.length() + 1;
                }
                if (Character.isWhitespace(sql.charAt(querySepIndex - 1))) {
                    return querySep.length() + 2;
                }
            }
        } else if (sql.length() - 1 == i && querySepIndex + querySep.length() - 1 == i) {
            if (0 == querySepIndex) {
                return querySep.length();
            }
            if (Character.isWhitespace(sql.charAt(querySepIndex - 1))) {
                return querySep.length() + 1;
            }
        }
        return -1;
    }

    @Override
    public boolean hasQuery() {
        return this._queryIterator.hasNext();
    }

    @Override
    public QueryHolder nextQuery() {
        return this._queryIterator.next();
    }

    @Override
    public void setScriptToTokenize(String script) {
        this._queries.clear();
        script = script.replace('\r', ' ');
        StringBuffer curQuery = new StringBuffer();
        StringBuffer curOriginalQuery = new StringBuffer();
        SQLCommentAndLiteralHandler commentAndLiteralHandler = new SQLCommentAndLiteralHandler(script, this._lineCommentBegin, this._removeMultiLineComment, this._removeLineComment);
        for (int i = 0; i < script.length(); ++i) {
            NextPositionAction nextPositionAction = commentAndLiteralHandler.nextPosition(i);
            curOriginalQuery.append(script.charAt(i));
            if (NextPositionAction.APPEND != nextPositionAction) continue;
            curQuery.append(script.charAt(i));
            int querySepLen = this.getLenOfQuerySepIfAtLastCharOfQuerySep(script, i, this._querySep, commentAndLiteralHandler.isInLiteral());
            if (-1 >= querySepLen || commentAndLiteralHandler.isInMultiLineComment()) continue;
            int newLength = curQuery.length() - querySepLen;
            if (-1 < newLength && curQuery.length() > newLength) {
                curQuery.setLength(newLength);
                String newQuery = curQuery.toString().trim();
                if (0 < newQuery.length()) {
                    this._queries.add(new QueryHolder(curQuery.toString().trim(), curOriginalQuery.toString().trim()));
                }
            }
            curQuery.setLength(0);
            curOriginalQuery.setLength(0);
        }
        String lastQuery = curQuery.toString().trim();
        String lastOriginalQuery = curOriginalQuery.toString().trim();
        if (0 < lastQuery.length()) {
            this._queries.add(new QueryHolder(lastQuery, lastOriginalQuery));
        }
        this._queryIterator = this._queries.iterator();
    }

    @Override
    public int getQueryCount() {
        if (this._queries == null) {
            return 0;
        }
        return this._queries.size();
    }

    public static void main(String[] args) {
        String sql = "/*My Multiline\\nArticles\\n*/\\nSELECT * FROM articles";
        QueryTokenizer qt = new QueryTokenizer("GO", "--", true, true);
        qt.setScriptToTokenize(sql);
        while (qt.hasQuery()) {
            QueryHolder queryHolder = qt.nextQuery();
            System.out.println("### Query>" + queryHolder.getQuery() + "<");
            System.out.println("### Original Query>" + queryHolder.getOriginalQuery() + "<");
        }
    }

    public String getQuerySep() {
        return this._querySep;
    }

    public void setQuerySep(String sep) {
        this._querySep = sep;
    }

    @Override
    public String getLineCommentBegin() {
        return this._lineCommentBegin;
    }

    public void setLineCommentBegin(String commentBegin) {
        this._lineCommentBegin = commentBegin;
    }

    @Override
    public boolean isRemoveMultiLineComment() {
        return this._removeMultiLineComment;
    }

    @Override
    public boolean isRemoveLineComment() {
        return this._removeLineComment;
    }

    @Override
    public TokenizerSessPropsInteractions getTokenizerSessPropsInteractions() {
        return new TokenizerSessPropsInteractions();
    }

    public void setRemoveMultiLineComment(boolean multiLineComment) {
        this._removeMultiLineComment = multiLineComment;
    }

    public void setRemoveLineComment(boolean removeLineComment) {
        this._removeLineComment = removeLineComment;
    }

    protected void expandFileIncludes(String scriptIncludePrefix) {
        if (scriptIncludePrefix == null) {
            s_log.error("scriptIncludePrefix cannot be null ");
            return;
        }
        ArrayList<QueryHolder> tmp = new ArrayList<QueryHolder>();
        for (QueryHolder sql : this._queries) {
            if (sql.getQuery().startsWith(scriptIncludePrefix) && !SQLScriptServices.handledBySqlToFileHandler(sql)) {
                try {
                    String filename = sql.getQuery().substring(scriptIncludePrefix.length());
                    List<String> fileSQLs = this.getStatementsFromIncludeFile(filename);
                    for (String fileSQL : fileSQLs) {
                        tmp.add(new QueryHolder(fileSQL));
                    }
                    continue;
                }
                catch (Exception e) {
                    s_log.error("Unexpected error while attempting to include file from " + sql, e);
                    continue;
                }
            }
            tmp.add(sql);
        }
        this._queries = tmp;
    }

    private List<String> getStatementsFromIncludeFile(String filename) {
        if (filename.startsWith("'")) {
            filename = filename.substring(1);
        }
        if (filename.endsWith("'")) {
            filename = StringUtilities.chop(filename);
        }
        if (filename.endsWith("\n")) {
            filename = StringUtilities.chop(filename);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (s_log.isDebugEnabled()) {
            s_log.debug("Attemping to open file '" + filename + "'");
        }
        File f = new File(filename);
        StringBuffer fileLines = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String next = reader.readLine();
            while (next != null) {
                fileLines.append(next);
                fileLines.append("\n");
                next = reader.readLine();
            }
        }
        catch (Exception e) {
            s_log.error("Unexpected exception while reading lines from file (" + filename + ")", e);
        }
        if (fileLines.toString().length() > 0) {
            IQueryTokenizer qt = this.createQueryTokenizerClone();
            qt.setScriptToTokenize(fileLines.toString());
            while (qt.hasQuery()) {
                String sql = qt.nextQuery().getQuery();
                result.add(sql);
            }
        }
        return result;
    }

    @Override
    public IQueryTokenizer createQueryTokenizerClone() {
        IQueryTokenizer qt = this._tokenizerFactory != null ? this._tokenizerFactory.getTokenizer() : new QueryTokenizer(this._querySep, this._lineCommentBegin, this._removeMultiLineComment, this._removeLineComment);
        return qt;
    }

    @Override
    public String getSQLStatementSeparator() {
        return this._querySep;
    }
}

