/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql.tablenamefind;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.sqlscript.SQLScriptServices;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import net.sourceforge.squirrel_sql.fw.sql.tablenamefind.QualifyResult;
import net.sourceforge.squirrel_sql.fw.sql.tablenamefind.QualifyResultState;
import net.sourceforge.squirrel_sql.fw.sql.tablenamefind.SingleTableSqlEnum;
import net.sourceforge.squirrel_sql.fw.sql.tablenamefind.TableQualifyingService;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class TableNameFindService {
    private static final Pattern FILL_COLUMN_NAME_PATTERN = Pattern.compile(".+:([^:]+):[^:]+$");

    public static String findTableNameBySqlOrResultMetaData(String sql, ResultSet srcResult, ISession session) throws SQLException {
        QualifyResult qualifyResult = TableQualifyingService.qualifyIfNeeded(TableNameFindService.getFirstTableNameFromResultSetMetaData(srcResult, session), session);
        if (qualifyResult.getState() == QualifyResultState.EMPTY || qualifyResult.getState() == QualifyResultState.HEURISTIC_USED) {
            qualifyResult = TableQualifyingService.qualifyIfNeeded(TableNameFindService._findTableNameInSQL(sql), session);
        }
        if (qualifyResult.getState() == QualifyResultState.EMPTY) {
            return "PressCtrlH";
        }
        return qualifyResult.getTableName();
    }

    public static String findTableNameInSQL(String sql, ISession session) {
        return TableQualifyingService.qualifyIfNeeded(TableNameFindService._findTableNameInSQL(sql), session).getTableName();
    }

    private static String _findTableNameInSQL(String sql) {
        Pattern patternBeforeTable = Pattern.compile("SELECT\\s+[A-Z0-9_\\*\\.',\\s\"]*\\s+FROM\\s+([A-Z0-9_\\.\"]+)");
        String ucSql = sql.toUpperCase().trim();
        Matcher matcher = patternBeforeTable.matcher(ucSql = ucSql.replaceAll("\\`", ""));
        if (!matcher.find()) {
            return null;
        }
        String table = sql.trim().substring(matcher.start(1), matcher.end(1));
        String behindTable = ucSql.substring(matcher.end(1)).trim();
        SingleTableSqlEnum ret = TableNameFindService.behindTableAllowsEditing(behindTable);
        if (SingleTableSqlEnum.SINGLE_TABLE_SQL_UNKNOWN == ret) {
            Pattern patternBehindTable = behindTable.startsWith("AS") && 2 < behindTable.length() && Character.isWhitespace(behindTable.charAt(2)) ? Pattern.compile("AS\\s+([A-Z0-9_]+)\\s+") : Pattern.compile("([A-Z0-9_]+)\\s+|[A-Z0-9_]+$");
            matcher = patternBehindTable.matcher(behindTable);
            if (!matcher.find()) {
                return null;
            }
            String behindAlias = behindTable.substring(matcher.end(0)).trim();
            ret = TableNameFindService.behindTableAllowsEditing(behindAlias);
            if (SingleTableSqlEnum.SINGLE_TABLE_SQL_TRUE == ret) {
                return table;
            }
            return null;
        }
        if (SingleTableSqlEnum.SINGLE_TABLE_SQL_TRUE == ret) {
            return table;
        }
        return null;
    }

    public static String findTableNameInColumnDisplayDefinition(ColumnDisplayDefinition colDef) {
        Matcher matcher;
        if (!StringUtilities.isEmpty(colDef.getTableName(), true)) {
            return colDef.getTableName();
        }
        if (null != colDef.getResultMetaDataTable() && !StringUtilities.isEmpty(colDef.getResultMetaDataTable().getTableName(), true)) {
            return colDef.getResultMetaDataTable().getTableName();
        }
        if (!StringUtilities.isEmpty(colDef.getFullTableColumnName(), true) && (matcher = FILL_COLUMN_NAME_PATTERN.matcher(colDef.getFullTableColumnName())).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String getFirstTableNameFromResultSetMetaData(ResultSet srcResult, ISession session) throws SQLException {
        ResultSetMetaData metaData = srcResult.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            TableInfo tInfo = new TableInfo(metaData.getCatalogName(i), metaData.getSchemaName(i), metaData.getTableName(i), "TABLE", "", session.getMetaData());
            String tableName = SQLScriptServices.formatTableName(tInfo);
            if (StringUtilities.isEmpty(tableName, true)) continue;
            return tableName;
        }
        return null;
    }

    private static SingleTableSqlEnum behindTableAllowsEditing(String behindTable) {
        if (0 == behindTable.length()) {
            return SingleTableSqlEnum.SINGLE_TABLE_SQL_TRUE;
        }
        if (behindTable.startsWith("WHERE") || behindTable.startsWith("ORDER") || behindTable.startsWith("GROUP")) {
            return SingleTableSqlEnum.SINGLE_TABLE_SQL_TRUE;
        }
        if (behindTable.startsWith(",") || behindTable.startsWith("INNER") || behindTable.startsWith("LEFT") || behindTable.startsWith("RIGHT") || behindTable.startsWith("OUTER") || behindTable.startsWith(",")) {
            return SingleTableSqlEnum.SINGLE_TABLE_SQL_FALSE;
        }
        return SingleTableSqlEnum.SINGLE_TABLE_SQL_UNKNOWN;
    }
}

