/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.timeoutproxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.BufferingDatabaseMetaDataProvider;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.DatabaseMetaDataProvider;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.StaticTimeOutThreadPool;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MetaDataTimeOutInvocationHandler
implements InvocationHandler {
    private static final ILogger s_log = LoggerController.createLogger(MetaDataTimeOutInvocationHandler.class);
    private BufferingDatabaseMetaDataProvider _metaDataProvider;
    private long _timeOut;

    public MetaDataTimeOutInvocationHandler(DatabaseMetaDataProvider metaDataProvider, long timeOut) {
        this._metaDataProvider = new BufferingDatabaseMetaDataProvider(metaDataProvider);
        this._timeOut = timeOut;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Future<Object> future = StaticTimeOutThreadPool.submit(() -> method.invoke((Object)this._metaDataProvider.getDataBaseMetaData(), args));
        try {
            return future.get(this._timeOut, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            String msg = "Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occured.";
            s_log.error("Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occured.");
            throw new RuntimeException("Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occured.", e);
        }
    }
}

