/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.timeoutproxy;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.StaticTimeOutThreadPool;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.TimeOutUtil;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class StatementExecutionTimeOutHandler {
    private static final ILogger s_log = LoggerController.createLogger(StatementExecutionTimeOutHandler.class);

    public static PreparedStatement prepareStatement(ISQLConnection con, String sql) throws SQLException {
        long metaDataLoadingTimeOut = TimeOutUtil.getMetaDataLoadingTimeOutOfActiveSession();
        if (0L == metaDataLoadingTimeOut) {
            return con.prepareStatement(sql);
        }
        Future<Object> future = StaticTimeOutThreadPool.submit(() -> con.prepareStatement(sql));
        try {
            return (PreparedStatement)future.get(metaDataLoadingTimeOut, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            String msg = "Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occured.";
            s_log.error("Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occured.");
            throw new RuntimeException("Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occured.", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw Utilities.wrapRuntime(e);
        }
        catch (InterruptedException e) {
            throw Utilities.wrapRuntime(e);
        }
    }
}

