/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.timeoutproxy;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.StaticTimeOutThreadPool;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.TimeOutableCaller;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.TimeOutableInvoker;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TimeOutUtil {
    private static final ILogger s_log = LoggerController.createLogger(TimeOutUtil.class);
    public static final int STD_INVOKE_WITH_TIMEOUT_MILLIS = 300;

    public static long getMetaDataLoadingTimeOutOfActiveSession() {
        long metaDataLoadingTimeOut = Main.getApplication().getSquirrelPreferences().getSessionProperties().getMetaDataLoadingTimeOut();
        if (!Main.getApplication().getSessionManager().isInCreateSession() && null != Main.getApplication().getSessionManager().getActiveSession()) {
            metaDataLoadingTimeOut = Main.getApplication().getSessionManager().getActiveSession().getProperties().getMetaDataLoadingTimeOut();
        }
        return metaDataLoadingTimeOut;
    }

    public static void invokeWithTimeout(TimeOutableInvoker timeoutableInvoker) {
        boolean usedMetaDataLoadingTimeout = false;
        try {
            Future<Object> future = StaticTimeOutThreadPool.submit(() -> TimeOutUtil.runnableToCallableWrapperFunction(timeoutableInvoker));
            long metaDataLoadingTimeOutOfActiveSession = TimeOutUtil.getMetaDataLoadingTimeOutOfActiveSession();
            if (0L == metaDataLoadingTimeOutOfActiveSession) {
                future.get(300L, TimeUnit.MILLISECONDS);
            } else {
                future.get(metaDataLoadingTimeOutOfActiveSession, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException e) {
            if (usedMetaDataLoadingTimeout) {
                String msg = "Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occurred.";
                s_log.error("Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occurred.");
                throw new RuntimeException("Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occurred.", e);
            }
            throw Utilities.wrapRuntime(e);
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public static <T> T callWithTimeout(TimeOutableCaller<T> timeoutableCaller) {
        return TimeOutUtil.callWithTimeout(timeoutableCaller, 300);
    }

    public static <T> T callWithTimeout(TimeOutableCaller<T> timeoutableCaller, int timeOutMillis) {
        boolean usedMetaDataLoadingTimeout = false;
        try {
            Future<Object> future = StaticTimeOutThreadPool.submit(() -> timeoutableCaller.call());
            long metaDataLoadingTimeOutOfActiveSession = TimeOutUtil.getMetaDataLoadingTimeOutOfActiveSession();
            if (0L == metaDataLoadingTimeOutOfActiveSession) {
                return (T)future.get(timeOutMillis, TimeUnit.MILLISECONDS);
            }
            usedMetaDataLoadingTimeout = true;
            return (T)future.get(metaDataLoadingTimeOutOfActiveSession, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            if (usedMetaDataLoadingTimeout) {
                String msg = "Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occured.";
                s_log.error("Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occured.");
                throw new RuntimeException("Timeout as configured in menu File --> New Session Properties --> tab SQL --> section \"Meta data loading\" occured.", e);
            }
            throw Utilities.wrapRuntime(e);
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private static Object runnableToCallableWrapperFunction(TimeOutableInvoker timeoutableInvoker) {
        try {
            timeoutableInvoker.invoke();
            return null;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public static long getDefaultOrConfiguredTimeoutMillis() {
        long metaDataLoadingTimeOutOfActiveSession = TimeOutUtil.getMetaDataLoadingTimeOutOfActiveSession();
        if (0L == metaDataLoadingTimeOutOfActiveSession) {
            return 300L;
        }
        return metaDataLoadingTimeOutOfActiveSession;
    }
}

