/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IProxySettings;
import net.sourceforge.squirrel_sql.fw.util.ScriptLineFixer;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

public class IOUtilitiesImpl
implements IOUtilities {
    public static final int DISK_DATA_BUFFER_SIZE = 8192;
    private final ILogger s_log = LoggerController.createLogger(IOUtilitiesImpl.class);

    @Override
    public void closeInputStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                this.s_log.error("closeInputStream: Unable to close InputStream - " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void closeOutputStream(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception e) {
                this.s_log.error("closeOutpuStream: Unable to close OutputStream - " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e) {
                this.s_log.error("closeReader: Unable to close Reader - " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception e) {
                this.s_log.error("closeReader: Unable to close Writer - " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void flushWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (Exception e) {
                this.s_log.error("flushReader: Unable to flush Writer - " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void copyBytes(InputStream is, OutputStream os) throws IOException {
        int length;
        byte[] buffer = new byte[8192];
        while ((length = is.read(buffer)) > 0) {
            os.write(buffer, 0, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int copyBytesToFile(InputStream is, FileWrapper outputFile) throws IOException {
        BufferedOutputStream outputFileStream = null;
        int totalLength = 0;
        try {
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            outputFileStream = new BufferedOutputStream(new FileOutputStream(outputFile.getAbsolutePath()));
            byte[] buffer = new byte[8192];
            int length = 0;
            while ((length = is.read(buffer)) != -1) {
                totalLength += length;
                outputFileStream.write(buffer, 0, length);
            }
            this.closeOutputStream(outputFileStream);
        }
        catch (Throwable throwable) {
            this.closeOutputStream(outputFileStream);
            throw throwable;
        }
        return totalLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCheckSum(File f) throws IOException {
        CRC32 result = new CRC32();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            int len = 0;
            byte[] buffer = new byte[8192];
            while ((len = fis.read(buffer)) != -1) {
                result.update(buffer, 0, len);
            }
        }
        finally {
            this.closeInputStream(fis);
        }
        return result.getValue();
    }

    @Override
    public long getCheckSum(FileWrapper f) throws IOException {
        return this.getCheckSum(new File(f.getAbsolutePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(FileWrapper from, FileWrapper to) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(from.getAbsolutePath());
            out = new FileOutputStream(to.getAbsolutePath());
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            this.closeInputStream(in);
            this.closeOutputStream(out);
        }
        catch (Throwable throwable) {
            this.closeInputStream(in);
            this.closeOutputStream(out);
            throw throwable;
        }
    }

    @Override
    public URL constructHttpUrl(String host, int port, String fileToGet) throws MalformedURLException {
        URL url = null;
        String server = host;
        if (server.startsWith("http")) {
            int beginIdx = server.indexOf("://") + 3;
            server = server.substring(beginIdx, host.length());
        }
        url = port == 80 ? new URL("http", server, fileToGet) : new URL("http", server, port, fileToGet);
        return url;
    }

    @Override
    public int downloadHttpFile(URL url, FileWrapper destFile, IProxySettings proxySettings) throws IOException {
        BufferedInputStream is = null;
        GetMethod method = null;
        int resultCode = -1;
        int result = -1;
        try {
            if (this.s_log.isDebugEnabled()) {
                this.s_log.debug("downloadHttpFile: downloading file (" + destFile.getName() + ") from url: " + url);
            }
            HttpClient client = new HttpClient();
            this.setupProxy(proxySettings, client, url);
            method = new GetMethod(url.toString());
            method.setFollowRedirects(true);
            resultCode = client.executeMethod((HttpMethod)method);
            if (this.s_log.isDebugEnabled()) {
                this.s_log.debug("downloadHttpFile: response code was: " + resultCode);
            }
            if (resultCode != 200) {
                throw new FileNotFoundException("Failed to download file from url (" + url + "): HTTP Response Code=" + resultCode);
            }
            InputStream mis = method.getResponseBodyAsStream();
            is = new BufferedInputStream(mis);
            if (this.s_log.isDebugEnabled()) {
                this.s_log.debug("downloadHttpFile: writing http response body to file: " + destFile.getAbsolutePath());
            }
            result = this.copyBytesToFile(mis, destFile);
            this.closeInputStream(is);
        }
        catch (IOException e) {
            try {
                this.s_log.error("downloadHttpFile: Unexpected exception while attempting to open an HTTP connection to url (" + url + ") to download a file (" + destFile.getAbsolutePath() + "): " + e.getMessage(), e);
                throw e;
            }
            catch (Throwable throwable) {
                this.closeInputStream(is);
                method.releaseConnection();
                throw throwable;
            }
        }
        method.releaseConnection();
        return result;
    }

    private void setupProxy(IProxySettings proxySettings, HttpClient client, URL url) {
        if (proxySettings == null) {
            return;
        }
        if (!proxySettings.getHttpUseProxy()) {
            return;
        }
        if (proxySettings.getHttpNonProxyHosts() != null && proxySettings.getHttpNonProxyHosts().contains(url.getHost())) {
            return;
        }
        String proxyHost = proxySettings.getHttpProxyServer();
        int proxyPort = Integer.parseInt(proxySettings.getHttpProxyPort());
        String proxyUsername = proxySettings.getHttpProxyUser();
        String proxyPassword = proxySettings.getHttpProxyPassword();
        client.getHostConfiguration().setProxy(proxyHost, proxyPort);
        if (proxyUsername != null && !"".equals(proxyUsername)) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
            client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
        }
    }

    @Override
    public List<String> getLinesFromFile(String filename, List<ScriptLineFixer> lineFixers) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (lineFixers != null) {
                for (ScriptLineFixer fixer : lineFixers) {
                    line = fixer.fixLine(filename, line);
                }
            }
            lines.add(line);
        }
        reader.close();
        return lines;
    }

    @Override
    public void writeLinesToFile(String filename, List<String> lines) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(new File(filename));
        for (String outline : lines) {
            out.write(outline);
            out.write(NEW_LINE);
        }
        out.close();
    }
}

