/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class JsonMarshalUtil {
    public static final ILogger s_log = LoggerController.createLogger(JsonMarshalUtil.class);

    public static void writeObjectToFile(File file, Object jsonBean) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            JsonMarshalUtil.writeObjectToBuffer(jsonBean, fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(Object obj) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        JsonMarshalUtil.writeObjectToBuffer(obj, bos);
        return bos.toString(StandardCharsets.UTF_8);
    }

    public static <T> T fromJsonString(String jsonString, Class<T> clazz) {
        return JsonMarshalUtil.readObjectFromStream(new ByteArrayInputStream(jsonString.getBytes()), clazz);
    }

    private static void writeObjectToBuffer(Object jsonBean, OutputStream os) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter objectWriter = mapper.writerWithDefaultPrettyPrinter();
            objectWriter.writeValue(os, jsonBean);
            os.close();
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public static <T> T readObjectFromFileSave(File file, Class<T> clazz, T fallBackReturnValue) {
        try {
            if (!file.exists()) {
                s_log.info("Json file " + file + " to load object of class " + clazz + ". Does not exist will return fallBackReturnValue.");
                return fallBackReturnValue;
            }
            return JsonMarshalUtil.readObjectFromFile(file, clazz);
        }
        catch (Throwable e) {
            s_log.warn("Could not read Json file " + file + " to load object of class " + clazz + ". Will return fallBackReturnValue.", e);
            return fallBackReturnValue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readObjectFromFile(File file, Class<T> clazz) {
        try (FileInputStream is = new FileInputStream(file);){
            T t = JsonMarshalUtil.readObjectFromStream(is, clazz);
            return t;
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T readObjectFromStream(InputStream is, Class<T> clazz) {
        try (InputStreamReader isr = new InputStreamReader(is, JsonEncoding.UTF8.getJavaName());){
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Object object = mapper.readValue((Reader)isr, (JavaType)SimpleType.construct(clazz));
            return (T)object;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }
}

