/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.IObjectCache;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCacheChangeEvent;

public class ObjectCache<E extends IHasIdentifier>
implements IObjectCache<E> {
    private Map<Class<E>, CacheEntry<E>> _entries = new HashMap<Class<E>, CacheEntry<E>>();

    @Override
    public synchronized IHasIdentifier get(Class<E> objClass, IIdentifier id) {
        return this.getCacheEntry(objClass).get(id);
    }

    @Override
    public synchronized void add(E obj) throws DuplicateObjectException {
        this.getCacheEntry(obj.getClass()).add(obj);
    }

    @Override
    public synchronized void remove(Class<E> objClass, IIdentifier id) {
        this.getCacheEntry(objClass).remove(id);
    }

    @Override
    public void addChangesListener(IObjectCacheChangeListener lis, Class<E> objClass) {
        this.getCacheEntry(objClass).addChangesListener(lis);
    }

    @Override
    public void removeChangesListener(IObjectCacheChangeListener lis, Class<E> objClass) {
        this.getCacheEntry(objClass).removeChangesListener(lis);
    }

    @Override
    public synchronized Class<E>[] getAllClasses() {
        ArrayList<Class<E>> classes = new ArrayList<Class<E>>();
        Iterator<Class<E>> it = this._entries.keySet().iterator();
        while (it.hasNext()) {
            classes.add(it.next());
        }
        if (classes.size() > 0) {
            return classes.toArray(new Class[classes.size()]);
        }
        return new Class[0];
    }

    @Override
    public synchronized Iterator<E> getAllForClass(Class<E> objClass) {
        return this.getCacheEntry(objClass).values().iterator();
    }

    @Override
    public List<E> getAllForClassAsList(Class<E> objClass) {
        return new ArrayList<E>(this.getCacheEntry(objClass).values());
    }

    private CacheEntry<E> getCacheEntry(Class<E> objClass) {
        CacheEntry<E> entry = this._entries.get(objClass);
        if (entry == null) {
            entry = new CacheEntry<E>(objClass);
            this._entries.put(objClass, entry);
        }
        return entry;
    }

    private final class CacheEntry<T extends E> {
        private Class<? extends T> _objClass;
        private Map<IIdentifier, T> _coll = new HashMap<IIdentifier, T>();
        private EventListenerList _listenerList = new EventListenerList();

        CacheEntry(Class<? extends T> objClass) {
            this._objClass = objClass;
        }

        IHasIdentifier get(IIdentifier id) {
            return (IHasIdentifier)this._coll.get(id);
        }

        void add(T obj) throws DuplicateObjectException, IllegalArgumentException {
            if (this.get(obj.getIdentifier()) != null) {
                throw new DuplicateObjectException((IHasIdentifier)obj);
            }
            if (!this._objClass.isInstance(obj)) {
                throw new IllegalArgumentException("IHasIdentifier is not an instance of " + this._objClass.getName());
            }
            this._coll.put(obj.getIdentifier(), obj);
            this.fireObjectAdded((IHasIdentifier)obj);
        }

        void remove(IIdentifier id) {
            IHasIdentifier obj = this.get(id);
            if (obj != null) {
                this._coll.remove(id);
                this.fireObjectRemoved(obj);
            }
        }

        Collection<T> values() {
            return this._coll.values();
        }

        void addChangesListener(IObjectCacheChangeListener lis) {
            this._listenerList.add(IObjectCacheChangeListener.class, lis);
        }

        void removeChangesListener(IObjectCacheChangeListener lis) {
            this._listenerList.remove(IObjectCacheChangeListener.class, lis);
        }

        private void fireObjectAdded(IHasIdentifier obj) {
            Object[] listeners = this._listenerList.getListenerList();
            ObjectCacheChangeEvent evt = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IObjectCacheChangeListener.class) continue;
                if (evt == null) {
                    evt = new ObjectCacheChangeEvent(obj);
                }
                ((IObjectCacheChangeListener)listeners[i + 1]).objectAdded(evt);
            }
        }

        private void fireObjectRemoved(IHasIdentifier obj) {
            Object[] listeners = this._listenerList.getListenerList();
            ObjectCacheChangeEvent evt = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IObjectCacheChangeListener.class) continue;
                if (evt == null) {
                    evt = new ObjectCacheChangeEvent(obj);
                }
                ((IObjectCacheChangeListener)listeners[i + 1]).objectRemoved(evt);
            }
        }
    }
}

