/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class StringUtilities {
    public static final String NULL_AS_STRING = "<null>";
    public static final char[] ILLEGAL_FILE_NAME_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};

    public static String cleanString(String str) {
        StringBuilder buf = new StringBuilder(str.length());
        char prevCh = ' ';
        int limit = str.length();
        for (int i = 0; i < limit; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (!Character.isWhitespace(prevCh)) {
                    buf.append(' ');
                }
            } else {
                buf.append(ch);
            }
            prevCh = ch;
        }
        return buf.toString().trim();
    }

    public static String[] split(String str, char delimiter) {
        return StringUtilities.split(str, delimiter, false);
    }

    public static String[] split(String str, char delimiter, boolean removeEmpty) {
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        String elem = null;
        int i = 0;
        int j = 0;
        while (j != -1 && j < len) {
            j = str.indexOf(delimiter, i);
            elem = j != -1 ? str.substring(i, j) : str.substring(i);
            i = j + 1;
            if (removeEmpty && (elem == null || elem.length() == 0)) continue;
            result.add(elem);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String join(String[] parts, String delim) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            result.append(part);
            if (delim == null || i >= parts.length - 1) continue;
            result.append(delim);
        }
        return result.toString();
    }

    public static String[] segment(String source, int maxSegmentSize) {
        ArrayList<String> tmp = new ArrayList<String>();
        if (source.length() <= maxSegmentSize) {
            return new String[]{source};
        }
        boolean done = false;
        int currBeginIdx = 0;
        int currEndIdx = maxSegmentSize;
        while (!done) {
            String segment = source.substring(currBeginIdx, currEndIdx);
            tmp.add(segment);
            if (currEndIdx >= source.length()) {
                done = true;
                continue;
            }
            currBeginIdx = currEndIdx;
            if ((currEndIdx += maxSegmentSize) <= source.length()) continue;
            currEndIdx = source.length();
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    public static int getTokenBeginIndex(String selectSQL, String token) {
        String lowerSel = selectSQL.toLowerCase();
        String lowerToken = token.toLowerCase().trim();
        int curPos = 0;
        int count = 0;
        while (-1 != curPos) {
            if (-1 < (curPos = lowerSel.indexOf(lowerToken, curPos + lowerToken.length())) && (0 == curPos || Character.isWhitespace(lowerSel.charAt(curPos - 1))) && (lowerSel.length() == curPos + lowerToken.length() || Character.isWhitespace(lowerSel.charAt(curPos + lowerToken.length())))) {
                return curPos;
            }
            if (count++ <= selectSQL.length()) continue;
            break;
        }
        return curPos;
    }

    public static Byte[] getByteArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new Byte[0];
        }
        Byte[] result = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[i];
        }
        return result;
    }

    public static String chop(String aString) {
        if (aString == null) {
            return null;
        }
        if (aString.length() == 0) {
            return "";
        }
        if (aString.length() == 1) {
            return "";
        }
        return aString.substring(0, aString.length() - 1);
    }

    public static String getEolStr() {
        return System.getProperty("line.separator", "\n");
    }

    public static String escapeHtmlChars(String sql) {
        String buf = sql.replaceAll("&", "&amp;");
        buf = buf.replaceAll("<", "&lt;");
        buf = buf.replaceAll(">", "&gt;");
        buf = buf.replaceAll("\"", "&quot;");
        return buf;
    }

    public static String javaNormalize(String text) {
        return StringUtilities.javaNormalize(text, true);
    }

    public static String javaNormalize(String text, boolean ensureJavaStart) {
        StringBuilder buf = new StringBuilder(text.length());
        if (ensureJavaStart && Character.isJavaIdentifierStart(text.charAt(0))) {
            buf.append(text.charAt(0));
        } else if (!ensureJavaStart && Character.isLetterOrDigit(text.charAt(0))) {
            buf.append(text.charAt(0));
        } else {
            buf.append('_');
        }
        for (int i = 1; i < text.length(); ++i) {
            if (Character.isLetterOrDigit(text.charAt(i))) {
                buf.append(text.charAt(i));
                continue;
            }
            buf.append('_');
        }
        String ret = buf.toString();
        return ret;
    }

    public static String fileNameNormalize(String text) {
        StringBuilder buf = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            boolean illegal = false;
            for (char illegalFileNameChar : ILLEGAL_FILE_NAME_CHARACTERS) {
                if (text.charAt(i) != illegalFileNameChar) continue;
                illegal = true;
                break;
            }
            if (illegal) {
                buf.append('_');
                continue;
            }
            buf.append(text.charAt(i));
        }
        return buf.toString().trim();
    }

    public static boolean isEmpty(String s) {
        return StringUtilities.isEmpty(s, false);
    }

    public static boolean isEmpty(String s, boolean checkTrimmed) {
        if (null == s) {
            return true;
        }
        if (checkTrimmed) {
            return 0 == s.trim().length();
        }
        return 0 == s.length();
    }

    public static boolean isNotEmpty(String s) {
        return StringUtilities.isNotEmpty(s, false);
    }

    public static boolean isNotEmpty(String s, boolean checkTrimmed) {
        return !StringUtilities.isEmpty(s, checkTrimmed);
    }

    public static String singleQuote(String value) {
        if (!value.trim().startsWith("'")) {
            return "'" + value + "'";
        }
        return value;
    }

    public static String emptyToNull(String s) {
        if (StringUtilities.isEmpty(s, true)) {
            return null;
        }
        return s;
    }

    public static String nullToEmpty(String str) {
        if (null == str) {
            return "";
        }
        return str;
    }

    public static String shortenBegin(String in, int maxLen, String incompleteIndikator) {
        if (in.length() <= maxLen) {
            return in;
        }
        if (null == incompleteIndikator) {
            return in.substring(in.length() - maxLen);
        }
        return incompleteIndikator + in.substring(in.length() - maxLen);
    }

    public static String shortenEnd(String in, int maxLen, String incompleteIndikator) {
        if (in.length() <= maxLen) {
            return in;
        }
        if (null == incompleteIndikator) {
            return in.substring(0, maxLen);
        }
        return in.substring(0, maxLen) + incompleteIndikator;
    }

    public static boolean equalsRespectNullModuloEmptyAndWhiteSpace(String s1, String s2) {
        return StringUtilities.equalsRespectNullModuloEmptyAndWhiteSpace(s1, s2, false);
    }

    public static boolean equalsRespectNullModuloEmptyAndWhiteSpace(String s1, String s2, boolean ignoreCase) {
        if (StringUtilities.isEmpty(s1, true) && StringUtilities.isEmpty(s2, true)) {
            return true;
        }
        if (StringUtilities.isEmpty(s1, true) || StringUtilities.isEmpty(s2, true)) {
            return false;
        }
        if (ignoreCase) {
            return s1.trim().equalsIgnoreCase(s2.trim());
        }
        return s1.trim().equals(s2.trim());
    }

    public static String removeCarriageReturn(String text) {
        if (null == text) {
            return null;
        }
        return text.replaceAll("\r", "");
    }

    public static String removeNewLine(String text) {
        if (null == text) {
            return null;
        }
        return StringUtilities.removeCarriageReturn(text).replaceAll("\n", "");
    }

    public static String prefixNulls(int toPrefix, int digitCount) {
        String ret = "" + toPrefix;
        while (ret.length() < digitCount) {
            ret = "0" + ret;
        }
        return ret;
    }

    public static String stripDoubleQuotes(String possiblyQuotedString) {
        if (StringUtilities.isEmpty(possiblyQuotedString, true)) {
            return possiblyQuotedString;
        }
        return StringUtils.strip((String)possiblyQuotedString, (String)"\"");
    }

    public static String pad(int width, char padChar) {
        return new String(new char[width]).replace('\u0000', padChar);
    }

    public static String removeEmptyLines(String text) {
        return StringUtilities.removeEmptyLines(text, s -> false);
    }

    public static String removeEmptyLines(String text, Predicate<String> previousLineVeto) {
        String[] lines = text.split("\n");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            boolean append = false;
            if (!lines[i].trim().isEmpty()) {
                append = true;
            } else if (previousLineVeto.test(lines[i - 1])) {
                append = true;
            }
            if (!append) continue;
            if (0 < builder.length()) {
                builder.append("\n");
            }
            builder.append(lines[i]);
        }
        return builder.toString();
    }

    public static String replaceNonBreakingSpacesBySpaces(String text) {
        return StringUtils.replaceChars((String)text, (String)"\u00a0\u1680\u180e\u2000\u200a\u202f\u205f\u3000", (String)" ");
    }
}

