/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDate;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTime;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTimestamp;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.TemporalScriptGenerationFormat;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class TemporalUtils {
    public static String format(Date date, int sqlType) {
        return TemporalUtils.format(date, sqlType, null);
    }

    public static String format(Date date, int sqlType, ISession session) {
        if (TemporalUtils.useStdJDBCFormat(sqlType)) {
            return TemporalUtils.getStdJDBCFormat(date, sqlType, session);
        }
        return TemporalUtils.getStringFormat(date, sqlType, session);
    }

    private static boolean useStdJDBCFormat(int sqlType) {
        if (sqlType == 93) {
            return DataTypeTimestamp.getTimeStampScriptFormat() == TemporalScriptGenerationFormat.STD_JDBC_FORMAT;
        }
        if (sqlType == 91) {
            return DataTypeDate.getDateScriptFormat() == TemporalScriptGenerationFormat.STD_JDBC_FORMAT;
        }
        if (sqlType == 92) {
            return DataTypeTime.getTimeScriptFormat() == TemporalScriptGenerationFormat.STD_JDBC_FORMAT;
        }
        return true;
    }

    public static String getStdJDBCFormat(Date date, int sqlType) {
        return TemporalUtils.getStdJDBCFormat(date, sqlType, null);
    }

    public static String getStdJDBCFormat(Date date, int sqlType, ISession session) {
        if (sqlType == 93) {
            if (date instanceof Timestamp) {
                return TemporalUtils.getStdJDBCFormat((Timestamp)date, session);
            }
            return TemporalUtils.getStdJDBCFormat(new Timestamp(date.getTime()), session);
        }
        if (sqlType == 91) {
            if (date instanceof java.sql.Date) {
                return TemporalUtils.getStdJDBCFormat((java.sql.Date)date);
            }
            return TemporalUtils.getStdJDBCFormat(new java.sql.Date(date.getTime()));
        }
        if (sqlType == 92) {
            if (date instanceof Time) {
                return TemporalUtils.getStdJDBCFormat((Time)date);
            }
            return TemporalUtils.getStdJDBCFormat(new Time(date.getTime()));
        }
        throw new IllegalArgumentException("Unknown temporal SQLType = " + sqlType);
    }

    public static String getStringFormat(Date date, int sqlType, ISession session) {
        if (sqlType == 93) {
            if (date instanceof Timestamp) {
                return TemporalUtils.getStringFormat((Timestamp)date);
            }
            return TemporalUtils.getStringFormat(new Timestamp(date.getTime()));
        }
        if (sqlType == 91) {
            if (date instanceof java.sql.Date) {
                return TemporalUtils.getStringFormat((java.sql.Date)date);
            }
            return TemporalUtils.getStringFormat(new java.sql.Date(date.getTime()));
        }
        if (sqlType == 92) {
            if (date instanceof Time) {
                return TemporalUtils.getStringFormat((Time)date);
            }
            return TemporalUtils.getStringFormat(new Time(date.getTime()));
        }
        throw new IllegalArgumentException("Unknown temporal SQLType = " + sqlType);
    }

    public static String getStdJDBCFormat(Timestamp timeStamp) {
        return TemporalUtils.getStdJDBCFormat(timeStamp, null);
    }

    public static String getStdJDBCFormat(Timestamp timeStamp, ISession session) {
        if (null == session) {
            return "{ts '" + timeStamp + "'}";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timeStamp);
        String esc = "{ts '" + StringUtilities.prefixNulls(calendar.get(1), 4) + "-" + StringUtilities.prefixNulls(calendar.get(2) + 1, 2) + "-" + StringUtilities.prefixNulls(calendar.get(5), 2) + " " + StringUtilities.prefixNulls(calendar.get(11), 2) + ":" + StringUtilities.prefixNulls(calendar.get(12), 2) + ":" + StringUtilities.prefixNulls(calendar.get(13), 2) + "." + TemporalUtils.getNanos(timeStamp, session) + "'}";
        return esc;
    }

    public static String getStringFormat(Timestamp timeStamp) {
        return "'" + timeStamp + "'";
    }

    public static String getStdJDBCFormat(java.sql.Date sqlDate) {
        return "{d '" + sqlDate + "'}";
    }

    public static String getStringFormat(java.sql.Date sqlDate) {
        return "'" + sqlDate + "'";
    }

    public static String getStdJDBCFormat(Time sqlTime) {
        return "{t '" + sqlTime + "'}";
    }

    public static String getStringFormat(Time sqlTime) {
        return "'" + sqlTime + "'";
    }

    public static String getNanos(Timestamp ts, ISession session) {
        if (null == session) {
            return "";
        }
        ISQLDatabaseMetaData md = session.getMetaData();
        HibernateDialect dialect = DialectFactory.getDialect(md);
        if (!dialect.supportsSubSecondTimestamps() || dialect.getTimestampMaximumFractionalDigits() == 0) {
            return "";
        }
        Object result = "" + ts.getNanos();
        int timestampMaximumFractionalDigits = dialect.getTimestampMaximumFractionalDigits();
        if (((String)result).length() >= timestampMaximumFractionalDigits) {
            result = ((String)result).substring(0, timestampMaximumFractionalDigits);
        }
        return result;
    }
}

