/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util.log;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.ILoggerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILoggerListener;
import net.sourceforge.squirrel_sql.fw.util.log.SQLLogCounts;
import net.sourceforge.squirrel_sql.fw.util.log.SQLoggerFactoryBase;
import net.sourceforge.squirrel_sql.fw.util.log.SQLoggerKernel;

public class LoggerController {
    private static ArrayList<ILoggerFactory> s_oldfactories = new ArrayList();
    private static ILoggerFactory s_factory = new SQLoggerFactoryBase();

    public static void registerLoggerFactory(ILoggerFactory factory) {
        s_oldfactories.add(s_factory);
        s_factory = factory != null ? factory : new SQLoggerFactoryBase();
    }

    public static ILogger createLogger(Class<?> clazz) {
        return s_factory.createLogger(clazz);
    }

    public static void shutdown() {
        s_factory.shutdown();
    }

    public static void addLoggerListener(ILoggerListener l) {
        s_factory.addLoggerListener(l);
        for (int i = 0; i < s_oldfactories.size(); ++i) {
            ILoggerFactory iLoggerFactory = s_oldfactories.get(i);
            iLoggerFactory.addLoggerListener(l);
        }
    }

    public static void removeLoggerListener(ILoggerListener l) {
        s_factory.removeLoggerListener(l);
        for (int i = 0; i < s_oldfactories.size(); ++i) {
            ILoggerFactory iLoggerFactory = s_oldfactories.get(i);
            iLoggerFactory.removeLoggerListener(l);
        }
    }

    public static SQLLogCounts getLogCounts() {
        return SQLoggerKernel.getLogCounts();
    }
}

