/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util.log;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.SQLogLevel;

public class SQLogWriter {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private SQLogLevel _minimumLogLevel = SQLogLevel.getMatchingLevel(ApplicationArguments.getInstance().getLogLevel());
    private File _executionLogFile = new ApplicationFiles().getExecutionLogFile();
    private ExecutorService _executorService = Executors.newSingleThreadExecutor();
    private long _lastSizeCheckMillis = 0L;

    public void printLog(Class clazz, SQLogLevel level, Object message, Throwable th) {
        if (!this._minimumLogLevel.higherOrEqual(level)) {
            return;
        }
        this._executorService.submit(() -> this.writeLogEntry(clazz, level, message, th));
    }

    public boolean isDebugEnabled() {
        return this._minimumLogLevel.higherOrEqual(SQLogLevel.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this._minimumLogLevel.higherOrEqual(SQLogLevel.INFO);
    }

    private void writeLogEntry(Class clazz, SQLogLevel level, Object message, Throwable th) {
        Date now = new Date();
        String logEntry = String.format("%s [%s] %s  %s  - %s\n%s", SIMPLE_DATE_FORMAT.format(now), Thread.currentThread().getName(), level.name(), this.getClassName(clazz), this.getMessage(message), Utilities.getStackTrace(th));
        try {
            if (0L == this._lastSizeCheckMillis) {
                this._lastSizeCheckMillis = now.getTime();
            } else if (now.getTime() - this._lastSizeCheckMillis > 10000L) {
                this._lastSizeCheckMillis = now.getTime();
                if (0x100000L <= this._executionLogFile.length()) {
                    Files.move(this._executionLogFile.toPath(), Paths.get(this._executionLogFile.getAbsolutePath() + "_old", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            Files.write(this._executionLogFile.toPath(), logEntry.getBytes(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (Exception e) {
            System.out.println("Error writing log message: " + logEntry);
            e.printStackTrace();
        }
    }

    private String getClassName(Class clazz) {
        if (null == clazz) {
            return "<classIsNull>";
        }
        return clazz.getName();
    }

    private String getMessage(Object message) {
        Object ret = "<messageIsNull>";
        if (null != message) {
            try {
                ret = message.toString();
            }
            catch (Throwable t) {
                ret = "<toString throws " + t + ">";
            }
        }
        return ret;
    }
}

