/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util.log;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.ILoggerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILoggerListener;
import net.sourceforge.squirrel_sql.fw.util.log.SquirrelLogger;

public class SQLoggerFactoryBase
implements ILoggerFactory {
    private ILoggerListener _listenerOfAllLoggers;
    private ArrayList<ILoggerListener> _listeners = new ArrayList();

    @Override
    public void addLoggerListener(ILoggerListener l) {
        this._listeners.add(l);
    }

    @Override
    public void removeLoggerListener(ILoggerListener l) {
        this._listeners.remove(l);
    }

    public SQLoggerFactoryBase() {
        this._listenerOfAllLoggers = new ILoggerListener(){

            @Override
            public void info(Class<?> source, Object message) {
                try {
                    ILoggerListener[] listeners = SQLoggerFactoryBase.this._listeners.toArray(new ILoggerListener[SQLoggerFactoryBase.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].info(source, message);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void info(Class<?> source, Object message, Throwable th) {
                try {
                    ILoggerListener[] listeners = SQLoggerFactoryBase.this._listeners.toArray(new ILoggerListener[SQLoggerFactoryBase.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].info(source, message, th);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void warn(Class<?> source, Object message) {
                try {
                    ILoggerListener[] listeners = SQLoggerFactoryBase.this._listeners.toArray(new ILoggerListener[SQLoggerFactoryBase.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].warn(source, message);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void warn(Class<?> source, Object message, Throwable th) {
                try {
                    ILoggerListener[] listeners = SQLoggerFactoryBase.this._listeners.toArray(new ILoggerListener[SQLoggerFactoryBase.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].warn(source, message, th);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void error(Class<?> source, Object message) {
                try {
                    ILoggerListener[] listeners = SQLoggerFactoryBase.this._listeners.toArray(new ILoggerListener[SQLoggerFactoryBase.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].error(source, message);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void error(Class<?> source, Object message, Throwable th) {
                try {
                    ILoggerListener[] listeners = SQLoggerFactoryBase.this._listeners.toArray(new ILoggerListener[SQLoggerFactoryBase.this._listeners.size()]);
                    for (int i = 0; i < listeners.length; ++i) {
                        listeners[i].error(source, message, th);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public ILogger createLogger(Class<?> clazz) {
        return new SquirrelLogger(clazz, this._listenerOfAllLoggers);
    }

    @Override
    public void shutdown() {
    }
}

