/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util.log;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.LogManager;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.SQLoggerFactoryBase;
import net.sourceforge.squirrel_sql.fw.util.log.SQLoggerKernel;

public class SquirrelLoggerFactory
extends SQLoggerFactoryBase {
    public SquirrelLoggerFactory() {
        this(true);
    }

    public SquirrelLoggerFactory(boolean withStartupLogging) {
        this.setAllLoggingFrameworkLoggersToWarning();
        SQLoggerKernel.init();
        if (withStartupLogging) {
            this.doStartupLogging();
        }
    }

    private void doStartupLogging() {
        ILogger log = this.createLogger(this.getClass());
        log.info("#############################################################################################################");
        log.info("# Starting " + Version.getVersion() + " at " + DateFormat.getInstance().format(new Date()));
        log.info("#############################################################################################################");
        log.info(Version.getVersion() + " started: " + Calendar.getInstance().getTime());
        log.info(Version.getCopyrightStatement().replace('\n', ' '));
        log.info("java.vendor: " + System.getProperty("java.vendor"));
        log.info("java.version: " + System.getProperty("java.version"));
        log.info("java.runtime.name: " + System.getProperty("java.runtime.name"));
        log.info("os.name: " + System.getProperty("os.name"));
        log.info("os.version: " + System.getProperty("os.version"));
        log.info("os.arch: " + System.getProperty("os.arch"));
        log.info("user.dir: " + System.getProperty("user.dir"));
        log.info("user.home: " + System.getProperty("user.home"));
        log.info("java.home: " + System.getProperty("java.home"));
        log.info("java.class.path: " + System.getProperty("java.class.path"));
        if (!StringUtilities.isEmpty(ApplicationArguments.getInstance().getLoggingConfigFileName(), true)) {
            log.warn("The logging configuration file command line argument (short option:" + ApplicationArguments.IOptions.LOG_FILE[0] + " / long option: " + ApplicationArguments.IOptions.LOG_FILE[1] + ") is unused since Log4J was removed from SQuirreL. Please remove the argument from your SQuirreL start script.");
        }
    }

    private void setAllLoggingFrameworkLoggersToWarning() {
        Enumeration<String> loggerNames = LogManager.getLogManager().getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            LogManager.getLogManager().getLogger(loggerNames.nextElement()).setLevel(Level.WARNING);
        }
    }
}

