/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.xml;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.beanwrapper.StringWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLBeanReader
implements Iterable<Object> {
    private static final ILogger s_log = LoggerController.createLogger(XMLBeanReader.class);
    private String[][] _fixStrings = new String[][]{{"com.bigfoot.colbell.squirrel", "net.sourceforge.squirrel_sql.client"}, {"com.bigfoot.colbell.fw", "net.sourceforge.squirrel_sql.fw"}, {"net.sourceforge.squirrel_sql.client.mainframe.MainFrameWindowState", "net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrameWindowState"}};
    private ClassLoader _cl;
    private final List<Object> _beanColl = new ArrayList<Object>();

    public void load(FileWrapper xmlFileWrapper) throws FileNotFoundException, XMLException {
        this.load(xmlFileWrapper.getAbsolutePath());
    }

    public void load(File xmlFile) throws FileNotFoundException, XMLException {
        this.load(xmlFile, null);
    }

    public void load(FileWrapper xmlFile, ClassLoader cl) throws FileNotFoundException, XMLException {
        if (!xmlFile.exists()) {
            throw new FileNotFoundException(xmlFile.getName());
        }
        this.load(xmlFile.getAbsolutePath(), cl);
    }

    public void load(File xmlFile, ClassLoader cl) throws FileNotFoundException, XMLException {
        if (!xmlFile.exists()) {
            throw new FileNotFoundException(xmlFile.getName());
        }
        this.load(xmlFile.getAbsolutePath(), cl);
    }

    public void load(String xmlFileName) throws FileNotFoundException, XMLException {
        this.load(xmlFileName, null);
    }

    public synchronized void load(String xmlFileName, ClassLoader cl) throws FileNotFoundException, IllegalArgumentException, XMLException {
        if (xmlFileName == null) {
            throw new IllegalArgumentException("Null xmlFileName passed");
        }
        this._cl = cl;
        this._beanColl.clear();
        try (FileInputStream fis = new FileInputStream(xmlFileName);){
            this.load(fis, cl);
        }
        catch (IOException ex) {
            s_log.error("Error closing FileReader", ex);
        }
    }

    public void load(InputStream is) throws XMLException {
        this.load(is, null);
    }

    public void load(InputStream is, ClassLoader cl) throws XMLException {
        try {
            this._cl = cl;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            if (doc != null) {
                NodeList beans = doc.getDocumentElement().getChildNodes();
                for (int i = 0; i < beans.getLength(); ++i) {
                    Node node = beans.item(i);
                    if (1 != node.getNodeType() || !this.isBeanElement(node)) continue;
                    this._beanColl.add(this.loadBean(node));
                }
            }
        }
        catch (Exception ex) {
            throw new XMLException(ex);
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return this._beanColl.iterator();
    }

    public <T> List<T> getBeans() {
        return this._beanColl;
    }

    private Object loadBean(Node beanNode) throws XMLException {
        String beanClassName = null;
        try {
            beanClassName = this.getClassNameFromElement(beanNode);
            beanClassName = this.fixClassName(beanClassName);
            Class<?> beanClass = null;
            beanClass = this._cl == null ? Class.forName(beanClassName) : Class.forName(beanClassName, true, this._cl);
            Object bean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanInfo info = Introspector.getBeanInfo(bean.getClass(), 1);
            PropertyDescriptor[] propDesc = info.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> props = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < propDesc.length; ++i) {
                props.put(propDesc[i].getName(), propDesc[i]);
            }
            NodeList children = beanNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                PropertyDescriptor curProp;
                Node propNode = children.item(i);
                if (1 != propNode.getNodeType() || (curProp = (PropertyDescriptor)props.get(propNode.getNodeName())) == null) continue;
                this.loadProperty(bean, curProp, propNode);
            }
            return bean;
        }
        catch (Exception ex) {
            s_log.error("Unexpected exception while attempting to load xml bean " + ex.getMessage(), ex);
            throw new XMLException(ex);
        }
    }

    private void loadProperty(Object bean, PropertyDescriptor propDescr, Node propNode) throws XMLException {
        Method setter = propDescr.getWriteMethod();
        if (setter != null) {
            Class<?> parmType = setter.getParameterTypes()[0];
            Class<?> arrayType = parmType.getComponentType();
            String value = null;
            if (0 < propNode.getChildNodes().getLength()) {
                value = propNode.getChildNodes().item(0).getNodeValue();
            }
            if (value == null && parmType.isPrimitive()) {
                s_log.warn("Parameter type was primitive (" + parmType + "), but the value was null.  Skipping invokation of method: " + setter.getName() + " in declaring class: " + setter.getDeclaringClass());
                return;
            }
            if (this.isIndexedElement(propNode)) {
                Object[] data = this.loadIndexedProperty(propNode);
                try {
                    if (arrayType.getName().equals("java.lang.String")) {
                        Object[] stringData = new Object[data.length];
                        for (int i = 0; i < data.length; ++i) {
                            stringData[i] = ((StringWrapper)data[i]).getString();
                        }
                        data = stringData;
                    }
                    Object obj = Array.newInstance(arrayType, data.length);
                    System.arraycopy(data, 0, obj, 0, data.length);
                    setter.invoke(bean, obj);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (this.isBeanElement(propNode)) {
                Object data = this.loadBean(propNode);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Boolean.TYPE) {
                Boolean data = Boolean.valueOf(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Integer.TYPE) {
                Integer data = Integer.valueOf(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Short.TYPE) {
                Short data = Short.valueOf(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Long.TYPE) {
                Long data = Long.valueOf(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Float.TYPE) {
                Float data = Float.valueOf(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Double.TYPE) {
                Double data = Double.valueOf(value);
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            if (parmType == Character.TYPE) {
                Character data = value != null && value.length() > 0 ? Character.valueOf(value.charAt(0)) : Character.valueOf(' ');
                try {
                    setter.invoke(bean, data);
                }
                catch (Exception ex) {
                    throw new XMLException(ex);
                }
            }
            String data = value;
            try {
                setter.invoke(bean, data);
            }
            catch (Exception ex) {
                throw new XMLException(ex);
            }
        }
    }

    private Object[] loadIndexedProperty(Node beanElement) throws XMLException {
        ArrayList<Object> beans = new ArrayList<Object>();
        NodeList children = beanElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (1 != child.getNodeType()) continue;
            beans.add(this.loadBean(child));
        }
        return beans.toArray(new Object[beans.size()]);
    }

    private boolean isBeanElement(Node node) {
        return node.getAttributes().getNamedItem("Class") != null;
    }

    private boolean isIndexedElement(Node elem) {
        Node indexed = elem.getAttributes().getNamedItem("Indexed");
        if (null == indexed) {
            return false;
        }
        String att = indexed.getNodeValue();
        return att != null && att.equals("true");
    }

    private String getClassNameFromElement(Node elem) {
        return elem.getAttributes().getNamedItem("Class").getNodeValue();
    }

    private String fixClassName(String className) {
        for (int i = 0; i < this._fixStrings.length; ++i) {
            String from = this._fixStrings[i][0];
            if (!((String)className).startsWith(from)) continue;
            className = this._fixStrings[i][1] + ((String)className).substring(from.length());
            break;
        }
        return className;
    }
}

