/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.xml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.beanwrapper.StringWrapper;
import net.sourceforge.squirrel_sql.fw.xml.IXMLAboutToBeWritten;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XMLBeanWriter {
    private Element _rootElement;
    private Document _dom;

    public XMLBeanWriter() throws XMLException {
        this(null);
    }

    public XMLBeanWriter(Object bean) throws XMLException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this._dom = db.newDocument();
            this._rootElement = this._dom.createElement("Beans");
            if (bean != null) {
                this.addToRoot(bean);
            }
            this._dom.appendChild(this._rootElement);
        }
        catch (ParserConfigurationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public void addIteratorToRoot(Iterator it) throws XMLException {
        while (it.hasNext()) {
            this.addToRoot(it.next());
        }
    }

    public void addToRoot(Object bean) throws XMLException {
        try {
            this._rootElement.appendChild(this.createElement(bean, null));
        }
        catch (Exception ex) {
            throw new XMLException(ex);
        }
    }

    public void save(FileWrapper file) throws IOException {
        try (FileOutputStream fileOutputStream = file.getFileOutputStream();){
            this.save(fileOutputStream);
        }
    }

    public void save(String fileName) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            this.save(fos);
        }
    }

    public void save(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.save(fos);
        }
    }

    private void save(FileOutputStream fos) throws IOException {
        this.saveToOutputStream(fos);
    }

    public void saveToOutputStream(OutputStream os) {
        try {
            Transformer tr = this.createTransFormer();
            tr.transform(new DOMSource(this._rootElement), new StreamResult(os));
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private Transformer createTransFormer() {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            return tr;
        }
        catch (TransformerConfigurationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public String getAsString() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Transformer tr = this.createTransFormer();
            tr.transform(new DOMSource(this._rootElement), new StreamResult(bos));
            return bos.toString(StandardCharsets.UTF_8);
        }
        catch (TransformerException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private Element createElement(Object bean, String name) throws XMLException {
        Element elem = null;
        BeanInfo info = null;
        try {
            if (bean != null) {
                info = Introspector.getBeanInfo(bean.getClass(), Object.class);
            }
        }
        catch (IntrospectionException ex) {
            throw new XMLException(ex);
        }
        elem = this._dom.createElement(name != null ? name : "Bean");
        if (info != null) {
            if (bean instanceof IXMLAboutToBeWritten) {
                ((IXMLAboutToBeWritten)bean).aboutToBeWritten();
            }
            PropertyDescriptor[] propDesc = info.getPropertyDescriptors();
            elem = this._dom.createElement(name != null ? name : "Bean");
            elem.setAttribute("Class", bean.getClass().getName());
            for (int i = 0; i < propDesc.length; ++i) {
                this.processProperty(propDesc[i], bean, elem);
            }
        }
        return elem;
    }

    private void processProperty(PropertyDescriptor propDescr, Object bean, Element beanElem) throws XMLException {
        Method getter = propDescr.getReadMethod();
        if (getter != null) {
            try {
                String propName = propDescr.getName();
                Class<?> returnType = getter.getReturnType();
                if (returnType.isArray()) {
                    boolean isStringArray = returnType.getName().equals("[Ljava.lang.String;");
                    Object[] props = (Object[])getter.invoke(bean, (Object[])null);
                    if (props != null) {
                        Element indexElem = this._dom.createElement(propName);
                        indexElem.setAttribute("Indexed", "true");
                        beanElem.appendChild(indexElem);
                        for (int i = 0; i < props.length; ++i) {
                            if (isStringArray) {
                                StringWrapper sw = new StringWrapper((String)props[i]);
                                indexElem.appendChild(this.createElement(sw, "Bean"));
                                continue;
                            }
                            indexElem.appendChild(this.createElement(props[i], "Bean"));
                        }
                    }
                } else if (returnType == Boolean.TYPE || returnType == Integer.TYPE || returnType == Short.TYPE || returnType == Long.TYPE || returnType == Float.TYPE || returnType == Double.TYPE || returnType == Character.TYPE) {
                    Element propElem = this._dom.createElement(propName);
                    propElem.appendChild(this._dom.createTextNode("" + getter.invoke(bean, (Object[])null)));
                    beanElem.appendChild(propElem);
                } else if (returnType == String.class) {
                    Element propElem = this._dom.createElement(propName);
                    String getterRes = (String)getter.invoke(bean, (Object[])null);
                    if (null != getterRes) {
                        propElem.appendChild(this._dom.createTextNode(getterRes));
                    }
                    beanElem.appendChild(propElem);
                } else {
                    beanElem.appendChild(this.createElement(getter.invoke(bean, (Object[])null), propName));
                }
            }
            catch (Exception ex) {
                throw new XMLException(ex);
            }
        }
    }
}

