/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.IObjectCache;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCache;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;

public class XMLObjectCache<E extends IHasIdentifier>
implements IObjectCache<E> {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(XMLObjectCache.class);
    private ObjectCache<E> _cache = new ObjectCache();

    @Override
    public IHasIdentifier get(Class<E> objClass, IIdentifier id) {
        return this._cache.get(objClass, id);
    }

    @Override
    public void add(E obj) throws DuplicateObjectException {
        this._cache.add(obj);
    }

    @Override
    public void remove(Class<E> objClass, IIdentifier id) {
        this._cache.remove(objClass, id);
    }

    @Override
    public Class<E>[] getAllClasses() {
        return this._cache.getAllClasses();
    }

    @Override
    public Iterator<E> getAllForClass(Class<E> objClass) {
        return this._cache.getAllForClass(objClass);
    }

    @Override
    public List<E> getAllForClassAsList(Class<E> objClass) {
        return this._cache.getAllForClassAsList(objClass);
    }

    @Override
    public void addChangesListener(IObjectCacheChangeListener lis, Class<E> objClass) {
        this._cache.addChangesListener(lis, objClass);
    }

    @Override
    public void removeChangesListener(IObjectCacheChangeListener lis, Class<E> objClass) {
        this._cache.removeChangesListener(lis, objClass);
    }

    public void load(String xmlFileName) throws FileNotFoundException, XMLException, DuplicateObjectException {
        this.load(xmlFileName, null);
    }

    public void load(String xmlFileName, ClassLoader cl) throws FileNotFoundException, XMLException, DuplicateObjectException {
        XMLBeanReader rdr = new XMLBeanReader();
        rdr.load(xmlFileName, cl);
        for (Object obj : rdr) {
            if (!(obj instanceof IHasIdentifier)) {
                throw new XMLException(s_stringMgr.getString("XMLObjectCache.error.notimplemented"));
            }
            this.add((IHasIdentifier)obj);
        }
    }

    public synchronized void save(String xmlFilename) throws IOException, XMLException {
        XMLBeanWriter wtr = new XMLBeanWriter();
        Class<E>[] classes = this._cache.getAllClasses();
        for (int i = 0; i < classes.length; ++i) {
            Iterator<E> it = this._cache.getAllForClass(classes[i]);
            while (it.hasNext()) {
                wtr.addToRoot(it.next());
            }
        }
        wtr.save(xmlFilename);
    }

    public synchronized void saveAllForClass(String xmlFilename, Class<E> forClass) throws IOException, XMLException {
        XMLBeanWriter wtr = new XMLBeanWriter();
        Iterator<E> it = this._cache.getAllForClass(forClass);
        while (it.hasNext()) {
            wtr.addToRoot(it.next());
        }
        wtr.save(xmlFilename);
    }
}

