/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.smarttools.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.smarttools.SmarttoolsHelper;
import net.sourceforge.squirrel_sql.plugins.smarttools.comp.STButton;
import net.sourceforge.squirrel_sql.plugins.smarttools.gui.ISmarttoolFrame;

public class SmarttoolFindBadNullValuesFrame
extends DialogWidget
implements ISmarttoolFrame,
ActionListener {
    private final String INDENT = "   ";
    private final int START_WORKING = 1;
    private final int STOP_WORKING = 2;
    private static final ILogger log = LoggerController.createLogger(SmarttoolFindBadNullValuesFrame.class);
    private static final StringManager stringManager = StringManagerFactory.getStringManager(SmarttoolFindBadNullValuesFrame.class);
    private ISession session;
    private Thread threadWork = null;
    private boolean threadSuspended;
    private Vector<String> vecHeader = new Vector();
    private Vector<Vector<Object>> vecData = new Vector();
    private JLabel lblTitleTable = new JLabel();
    private JLabel lblTablename = new JLabel();
    private JTextField tfTablename = new JTextField();
    private STButton btnStart = new STButton();
    private STButton btnStop = new STButton();
    private JLabel lblTitleTableResult = new JLabel();
    private JLabel lblFooterTableResult = new JLabel();
    private STButton btnPrint = new STButton();
    private JTable tblResult = null;
    private JProgressBar pbMain = new JProgressBar();

    public SmarttoolFindBadNullValuesFrame(ISession session, String title) {
        super("Smarttool - " + title, true, true, true, true);
        this.session = session;
        this.initLayout();
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.moveToFront();
    }

    private void initLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.createTableHeader();
        this.tblResult = new JTable(this.vecData, this.vecHeader);
        this.getContentPane().add(this.createPanel());
        this.initVisualObjects();
    }

    public JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        FormLayout formlayout1 = new FormLayout("FILL:4DLU:NONE,FILL:DEFAULT:GROW(1.0),FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE", "CENTER:2DLU:NONE,FILL:DEFAULT:NONE,CENTER:DEFAULT:NONE,FILL:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:2DLU:NONE,FILL:DEFAULT:GROW(1.0),CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        this.pbMain.setName("pbMain");
        this.pbMain.setValue(25);
        jpanel1.add((Component)this.pbMain, cc.xywh(2, 11, 3, 1));
        this.tblResult.setName("taResult");
        JScrollPane jscrollpane1 = new JScrollPane();
        jscrollpane1.setViewportView(this.tblResult);
        jscrollpane1.setVerticalScrollBarPolicy(20);
        jscrollpane1.setHorizontalScrollBarPolicy(30);
        jpanel1.add((Component)jscrollpane1, cc.xywh(2, 7, 3, 1));
        jpanel1.add((Component)this.createpanelTableAndColumn(), cc.xy(2, 2));
        jpanel1.add((Component)this.createPanelButton(), cc.xy(4, 2));
        this.lblTitleTableResult.setBackground(new Color(102, 102, 102));
        this.lblTitleTableResult.setName("lblTitleTableResult");
        this.lblTitleTableResult.setOpaque(true);
        this.lblTitleTableResult.setText(" Searching for ...");
        jpanel1.add((Component)this.lblTitleTableResult, cc.xy(2, 4));
        this.lblFooterTableResult.setBackground(new Color(102, 102, 102));
        this.lblFooterTableResult.setName("lblFooterTableResult");
        this.lblFooterTableResult.setOpaque(true);
        this.lblFooterTableResult.setText(" Finshed in ...");
        jpanel1.add((Component)this.lblFooterTableResult, cc.xywh(2, 9, 3, 1));
        this.btnPrint.setActionCommand("Print");
        this.btnPrint.setName("btnPrint");
        this.btnPrint.setText("Print");
        jpanel1.add((Component)this.btnPrint, cc.xy(4, 4));
        return jpanel1;
    }

    public JPanel createpanelTableAndColumn() {
        JPanel jpanel1 = new JPanel();
        jpanel1.setName("panelTableAndColumn");
        EtchedBorder etchedborder1 = new EtchedBorder(0, null, null);
        jpanel1.setBorder(etchedborder1);
        FormLayout formlayout1 = new FormLayout("FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:GROW(1.0),FILL:4DLU:NONE", "CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        this.lblTitleTable.setBackground(new Color(102, 102, 102));
        this.lblTitleTable.setName("lblTitleTable");
        this.lblTitleTable.setOpaque(true);
        this.lblTitleTable.setText(" Used tables");
        jpanel1.add((Component)this.lblTitleTable, cc.xywh(1, 1, 5, 1));
        this.lblTablename.setName("lblTablename");
        this.lblTablename.setText("table name");
        jpanel1.add((Component)this.lblTablename, cc.xy(2, 3));
        this.tfTablename.setName("tfTablename");
        jpanel1.add((Component)this.tfTablename, cc.xy(4, 3));
        return jpanel1;
    }

    public JPanel createPanelButton() {
        JPanel jpanel1 = new JPanel();
        jpanel1.setName("panelButton");
        FormLayout formlayout1 = new FormLayout("FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        this.btnStart.setActionCommand("Start");
        this.btnStart.setName("btnStart");
        this.btnStart.setText("Start");
        jpanel1.add((Component)this.btnStart, cc.xy(1, 1));
        this.btnStop.setActionCommand("Stop");
        this.btnStop.setName("btnStop");
        this.btnStop.setText("Stop");
        jpanel1.add((Component)this.btnStop, cc.xy(1, 3));
        return jpanel1;
    }

    @Override
    public void setFocusToFirstEmptyInputField() {
    }

    private void initVisualObjects() {
        this.lblTitleTable.setText(i18n.LBL_TITLE_USED_TABLES);
        this.lblTablename.setText(i18n.LBL_TABLENAME);
        this.lblTitleTableResult.setText(" " + i18n.INFO_REPORT);
        this.lblFooterTableResult.setText("");
        this.tfTablename.setToolTipText(i18n.TOOLTIP_WILDCARD);
        this.btnStart.setText(i18n.LBL_BTN_START);
        this.btnStart.setIcon(SmarttoolsHelper.loadIcon("start16x16.png"));
        this.btnStart.addActionListener(this);
        this.btnStop.setText(i18n.LBL_BTN_STOP);
        this.btnStop.setIcon(SmarttoolsHelper.loadIcon("stop16x16.png"));
        this.btnStop.addActionListener(this);
        this.btnStop.setEnabled(false);
        this.btnPrint.setText(i18n.LBL_BTN_PRINT);
        this.btnPrint.setIcon(SmarttoolsHelper.loadIcon("printer16x16.png"));
        this.btnPrint.addActionListener(this);
        this.btnPrint.setEnabled(false);
        this.pbMain.setValue(0);
        this.pbMain.setStringPainted(true);
    }

    private void createTableHeader() {
        this.vecHeader.add(i18n.GLOBAL_TABLE);
        this.vecHeader.add(i18n.GLOBAL_COLUMN);
        this.vecHeader.add(i18n.GLOBAL_DATATYPE);
        this.vecHeader.add(i18n.GLOBAL_RECORDS);
    }

    public void controlComponents(int type) {
        if (type == 1 || type == 2) {
            boolean b = type == 2;
            this.tfTablename.setEnabled(b);
            this.btnStart.setEnabled(b);
            this.btnStop.setEnabled(!b);
            this.btnPrint.setEnabled(b && this.tblResult.getRowCount() > 0);
        }
    }

    private void startWork() {
        this.controlComponents(1);
        this.threadWork = new ThreadWork();
        this.threadWork.start();
    }

    private void stopWork() {
        this.threadSuspended = true;
        if (JOptionPane.showConfirmDialog((Component)this.session.getApplication().getMainFrame(), i18n.QUESTION_CANCEL_WORK, i18n.QUESTION_CANCEL_WORK_TITLE, 0) == 0) {
            this.threadWork = null;
            this.controlComponents(2);
        }
        this.threadSuspended = false;
    }

    private void printResult() {
        SmarttoolsHelper.printTable(this.tblResult, this.getTitle(), i18n.GLOBAL_ALIAS + ": " + this.session.getAlias().getName() + " | " + DateFormat.getDateTimeInstance(2, 3).format(new Date()) + " | " + i18n.GLOBAL_PAGE + " {0}");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnStart) {
            this.startWork();
        } else if (e.getSource() == this.btnStop) {
            this.stopWork();
        } else if (e.getSource() == this.btnPrint) {
            this.printResult();
        }
    }

    class ThreadWork
    extends Thread {
        private Thread thisThread = null;

        ThreadWork() {
        }

        @Override
        public void run() {
            super.run();
            this.thisThread = Thread.currentThread();
            this.startTest();
            SmarttoolFindBadNullValuesFrame.this.controlComponents(2);
            SmarttoolFindBadNullValuesFrame.this.threadWork = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isThreadInvalid() {
            if (this.thisThread != SmarttoolFindBadNullValuesFrame.this.threadWork) {
                return true;
            }
            try {
                ThreadWork threadWork = this;
                synchronized (threadWork) {
                    while (SmarttoolFindBadNullValuesFrame.this.threadSuspended) {
                        this.wait(200L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }

        private void startTest() {
            long startTime = System.currentTimeMillis();
            ((DefaultTableModel)SmarttoolFindBadNullValuesFrame.this.tblResult.getModel()).setDataVector(new Vector(), SmarttoolFindBadNullValuesFrame.this.vecHeader);
            String tableNamePattern = SmarttoolFindBadNullValuesFrame.this.tfTablename.getText().trim();
            if (tableNamePattern.length() == 0) {
                tableNamePattern = "%";
            }
            try {
                ITableInfo[] tableInfoArray = SmarttoolFindBadNullValuesFrame.this.session.getMetaData().getTables(null, null, tableNamePattern, new String[]{"TABLE"}, null);
                SmarttoolFindBadNullValuesFrame.this.lblFooterTableResult.setText("");
                SmarttoolFindBadNullValuesFrame.this.pbMain.setValue(0);
                SmarttoolFindBadNullValuesFrame.this.pbMain.setMaximum(tableInfoArray.length);
                for (int i = 0; i < tableInfoArray.length; ++i) {
                    ITableInfo tableInfo = tableInfoArray[i];
                    SmarttoolFindBadNullValuesFrame.this.pbMain.setString(tableInfo.getSimpleName() + " " + (i + 1) + "/" + SmarttoolFindBadNullValuesFrame.this.pbMain.getMaximum());
                    this.checkColumns(tableInfo);
                    SmarttoolFindBadNullValuesFrame.this.pbMain.setValue(i + 1);
                    SmarttoolFindBadNullValuesFrame.this.pbMain.repaint();
                    if (this.isThreadInvalid()) break;
                }
                long diffTime = System.currentTimeMillis() - startTime;
                SmarttoolFindBadNullValuesFrame.this.lblFooterTableResult.setText(" " + i18n.INFO_FINISHED + " " + diffTime + " ms");
            }
            catch (SQLException e) {
                log.error((Object)e);
                JOptionPane.showMessageDialog(null, i18n.ERROR_READ_CHECKING_DATA);
            }
        }

        private void checkColumns(ITableInfo tableInfo) throws SQLException {
            TableColumnInfo[] columnInfos = SmarttoolFindBadNullValuesFrame.this.session.getMetaData().getColumnInfo(tableInfo);
            Statement stmt = SmarttoolFindBadNullValuesFrame.this.session.getSQLConnection().createStatement();
            int resultFound = 0;
            for (int c = 0; c < columnInfos.length; ++c) {
                TableColumnInfo tableColumnInfo = columnInfos[c];
                String sql = null;
                if (tableColumnInfo.isNullAllowed() == 0) {
                    sql = "SELECT COUNT(*) FROM " + tableInfo.getSimpleName() + " WHERE " + tableColumnInfo.getColumnName() + " IS NULL";
                }
                if (sql == null) continue;
                try {
                    resultFound = SmarttoolsHelper.checkColumnData(stmt, sql);
                    if (resultFound <= 0) continue;
                    this.addTableEntry(tableInfo.getSimpleName(), tableColumnInfo.getColumnName(), SmarttoolsHelper.getDataTypeForDisplay(tableColumnInfo), "" + resultFound);
                    continue;
                }
                catch (SQLException e) {
                    String text = "   " + i18n.ERROR_ON_TABLE + " [" + tableInfo.getSimpleName() + "] " + i18n.GLOBAL_COLUMN + " [" + tableColumnInfo.getColumnName() + "] :" + e.getLocalizedMessage();
                    this.addTableEntry(tableInfo.getSimpleName(), tableColumnInfo.getColumnName(), SmarttoolsHelper.getDataTypeForDisplay(tableColumnInfo), i18n.ERROR_ON_TABLE);
                    log.error((Object)text);
                }
            }
            stmt.close();
        }

        private void addTableEntry(String tableName, String columnName, String dataType, String recordsFound) {
            Vector<String> vecRow = new Vector<String>();
            vecRow.add(tableName);
            vecRow.add(columnName);
            vecRow.add(dataType);
            vecRow.add(recordsFound);
            DefaultTableModel tm = (DefaultTableModel)SmarttoolFindBadNullValuesFrame.this.tblResult.getModel();
            tm.addRow(vecRow);
            tm.fireTableDataChanged();
        }
    }

    private static interface i18n {
        public static final String LBL_TITLE_USED_TABLES = stringManager.getString("badnullvalues.title.tables");
        public static final String LBL_TABLENAME = stringManager.getString("badnullvalues.lbl.table.name");
        public static final String LBL_BTN_START = stringManager.getString("global.lbl.btn.start");
        public static final String LBL_BTN_STOP = stringManager.getString("global.lbl.btn.stop");
        public static final String LBL_BTN_PRINT = stringManager.getString("global.lbl.btn.print");
        public static final String TOOLTIP_WILDCARD = stringManager.getString("badnullvalues.tooltip.wildcard");
        public static final String TOOLTIP_BTN_PRINT = stringManager.getString("global.tooltip.btn.print");
        public static final String GLOBAL_RECORDS = stringManager.getString("global.records");
        public static final String GLOBAL_TABLE = stringManager.getString("global.table");
        public static final String GLOBAL_COLUMN = stringManager.getString("global.column");
        public static final String GLOBAL_DATATYPE = stringManager.getString("global.datatype");
        public static final String GLOBAL_PAGE = stringManager.getString("global.page");
        public static final String GLOBAL_ALIAS = stringManager.getString("global.alias");
        public static final String QUESTION_CANCEL_WORK = stringManager.getString("badnullvalues.question.cancel.work");
        public static final String QUESTION_CANCEL_WORK_TITLE = stringManager.getString("badnullvalues.question.cancel.work.title");
        public static final String ERROR_READ_CHECKING_DATA = stringManager.getString("badnullvalues.error.read.checking.data");
        public static final String ERROR_ON_TABLE = stringManager.getString("badnullvalues.error.on.table");
        public static final String INFO_FINISHED = stringManager.getString("badnullvalues.info.finished");
        public static final String INFO_REPORT = stringManager.getString("badnullvalues.info.report");
    }
}

