/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.highresicon;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.highresicon.HighResolutionIconPlugin;
import net.sourceforge.squirrel_sql.plugins.highresicon.IconScale;

public class HighResPrefsCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HighResPrefsCtrl.class);
    private final JPanel _panel;
    private JCheckBox _scaleIconsWithStaticText;
    private HighResolutionIconPlugin _plugin;

    public HighResPrefsCtrl(HighResolutionIconPlugin plugin) {
        this._plugin = plugin;
        this._panel = this.createPanel();
        this._scaleIconsWithStaticText.setSelected(this._plugin.getHighResPrefs().isScaleIconsWithText());
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(20, 0, 0, 0), 0, 0);
        this._scaleIconsWithStaticText = new JCheckBox(s_stringMgr.getString("HighResPrefsPanel.scaleIconsWithText"));
        panel.add((Component)this._scaleIconsWithStaticText, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        panel.add((Component)new JPanel(), gbc);
        return panel;
    }

    public void applyChanges() {
        this._plugin.getHighResPrefs().setScaleIconsWithText(this._scaleIconsWithStaticText.isSelected());
        JsonMarshalUtil.writeObjectToFile((File)this._plugin.getHighResPrefsFile(), (Object)this._plugin.getHighResPrefs());
        IconScale.setFollowTextSize(this._plugin.getHighResPrefs().isScaleIconsWithText());
    }

    public JPanel getPanel() {
        return this._panel;
    }
}

