/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.highresicon;

import java.io.File;
import java.io.IOException;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.plugin.DefaultPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.fw.resources.IconHandler;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.plugins.highresicon.HighResGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.plugins.highresicon.HighResIconHandler;
import net.sourceforge.squirrel_sql.plugins.highresicon.HighResPrefJsonBean;
import net.sourceforge.squirrel_sql.plugins.highresicon.IconScale;

public class HighResolutionIconPlugin
extends DefaultPlugin {
    static final String HIGH_RES_PREFS_FILE_NAME = "HiResPrefs.json";
    private HighResIconHandler _iconHandler;
    private HighResPrefJsonBean _highResPrefJsonBean = new HighResPrefJsonBean();

    public String getInternalName() {
        return "highresicon";
    }

    public String getDescriptiveName() {
        return "High resolution icon";
    }

    public String getVersion() {
        return "0.01";
    }

    public String getAuthor() {
        return "Stanimir Stamenkov";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.txt";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public String getContributors() {
        return "";
    }

    public void load(IApplication app) throws PluginException {
        File prefsFile = this.getHighResPrefsFile();
        if (prefsFile.exists()) {
            this._highResPrefJsonBean = (HighResPrefJsonBean)JsonMarshalUtil.readObjectFromFileSave((File)prefsFile, HighResPrefJsonBean.class, (Object)new HighResPrefJsonBean());
        }
        IconScale.setFollowTextSize(this._highResPrefJsonBean.isScaleIconsWithText());
        this._iconHandler = new HighResIconHandler();
        app.setIconHandler((IconHandler)this._iconHandler);
    }

    public File getHighResPrefsFile() {
        try {
            return new File(this.getPluginUserSettingsFolder().getFile(), HIGH_RES_PREFS_FILE_NAME);
        }
        catch (IOException e) {
            throw Utilities.wrapRuntime((Throwable)e);
        }
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        return new IGlobalPreferencesPanel[]{new HighResGlobalPreferencesPanel(this)};
    }

    public HighResPrefJsonBean getHighResPrefs() {
        return this._highResPrefJsonBean;
    }
}

