/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.highresicon;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.fw.util.SystemInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public final class IconScale {
    private static ILogger log = LoggerController.createLogger(IconScale.class);
    private static double factor = 1.0;
    private static PropertyChangeListener textSizeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "lookAndFeel": {
                    if (evt.getNewValue() instanceof LookAndFeel) {
                        UIManager.getLookAndFeelDefaults().addPropertyChangeListener(this);
                    }
                    IconScale.updateScaleFactor();
                    break;
                }
                case "Label.font": {
                    IconScale.updateScaleFactor();
                }
            }
        }
    };

    private IconScale() {
    }

    static void updateScaleFactor() {
        double scale;
        Font font = UIManager.getFont("Label.font");
        double baseFontSize = 12.0;
        if (SystemInfo.isWindows()) {
            if ("Tahoma".equals(font.getFamily())) {
                baseFontSize = 11.0;
            }
        } else if (SystemInfo.isMacOS()) {
            baseFontSize = 13.0;
        } else if (SystemInfo.isLinux()) {
            baseFontSize = SystemInfo.isIsKDE() ? 13.0 : 15.0;
        }
        IconScale.setFactor((scale = (double)font.getSize() / baseFontSize) > 1.0 ? (double)Math.round(scale * 4.0) / 4.0 : 1.0);
    }

    public static void setFollowTextSize(boolean follow) {
        if (follow) {
            UIManager.addPropertyChangeListener(textSizeListener);
            UIManager.getDefaults().addPropertyChangeListener(textSizeListener);
            UIManager.getLookAndFeelDefaults().addPropertyChangeListener(textSizeListener);
            IconScale.updateScaleFactor();
        } else {
            UIManager.removePropertyChangeListener(textSizeListener);
            UIManager.getDefaults().removePropertyChangeListener(textSizeListener);
            UIManager.getLookAndFeelDefaults().removePropertyChangeListener(textSizeListener);
            IconScale.setFactor(1.0);
        }
    }

    public static double getFactor() {
        return factor;
    }

    private static void setFactor(double factor) {
        IconScale.factor = factor;
        log.info((Object)("Icon scale: " + factor));
    }

    public static int ceil(double size) {
        return (int)Math.ceil(size * IconScale.getFactor());
    }

    public static int round(double size) {
        return (int)Math.round(size * IconScale.getFactor());
    }
}

