/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.highresicon;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.sourceforge.xbrz.tool.AwtXbrz;

class ImageScaler {
    ImageScaler() {
    }

    public static ImageScaler getInstance() {
        return new ImageScaler();
    }

    public Image scale(Image source, int destWidth, int destHeight) {
        return ImageScaler.incrementalDownscale(AwtXbrz.scaleImage((Image)source, (int)destWidth, (int)destHeight), destWidth, destHeight);
    }

    private static Image incrementalDownscale(Image source, int destWidth, int destHeight) {
        Image current = source;
        int currentWidth = source.getWidth(null);
        int currentHeight = source.getHeight(null);
        while (currentWidth > destWidth * 2 || currentHeight > destHeight * 2) {
            Image previous;
            if (currentWidth > destWidth * 2) {
                currentWidth /= 2;
            }
            if (currentHeight > destHeight * 2) {
                currentHeight /= 2;
            }
            if ((previous = current) != (current = ImageScaler.scaleSmooth(current, currentWidth, currentHeight))) continue;
            return current;
        }
        return ImageScaler.scaleSmooth(current, destWidth, destHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image scaleSmooth(Image source, int destWidth, int destHeight) {
        BufferedImage variant = new BufferedImage(destWidth, destHeight, 2);
        Graphics2D g = variant.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        try {
            Image image = g.drawImage(source, 0, 0, destWidth, destHeight, null) ? variant : source;
            return image;
        }
        finally {
            g.dispose();
        }
    }
}

