/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.highresicon;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.AbstractMultiResolutionImage;
import java.awt.image.ImageObserver;
import java.awt.image.MultiResolutionImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

abstract class MultiResolutionCachedImage
extends AbstractMultiResolutionImage {
    protected final int baseWidth;
    protected final int baseHeight;
    private Map<Dimension, Image> resolutionVariants = new LinkedHashMap<Dimension, Image>(2, 1.0f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Dimension, Image> eldest) {
            return this.size() > 2;
        }
    };

    protected MultiResolutionCachedImage(int baseWidth, int baseHeight) {
        this.baseWidth = baseWidth;
        this.baseHeight = baseHeight;
    }

    public static Image map(final Image image, final Function<Image, Image> mapper) {
        if (image instanceof MultiResolutionImage) {
            return new MultiResolutionCachedImage(image.getWidth(null), image.getHeight(null)){

                @Override
                protected Image createResolutionVariant(int destWidth, int destHeight) {
                    return (Image)mapper.apply(((MultiResolutionImage)((Object)image)).getResolutionVariant(destWidth, destHeight));
                }
            };
        }
        return mapper.apply(image);
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.baseWidth;
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.baseHeight;
    }

    @Override
    protected Image getBaseImage() {
        return this.getResolutionVariant(this.baseWidth, this.baseHeight);
    }

    @Override
    public Image getScaledInstance(int width, int height, int hints) {
        return this.getResolutionVariant(width, height);
    }

    @Override
    public Image getResolutionVariant(double destImageWidth, double destImageHeight) {
        int height;
        int width = (int)Math.ceil(destImageWidth);
        Dimension key = new Dimension(width, height = (int)Math.ceil(destImageHeight));
        Image variant = this.resolutionVariants.get(key);
        if (variant == null) {
            variant = this.createResolutionVariant(width, height);
            this.resolutionVariants.put(key, variant);
        }
        return variant;
    }

    @Override
    public List<Image> getResolutionVariants() {
        ArrayList<Image> variants = new ArrayList<Image>(this.resolutionVariants.values());
        if (variants.isEmpty()) {
            variants.add(this.getBaseImage());
        }
        return variants;
    }

    protected abstract Image createResolutionVariant(int var1, int var2);
}

