/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.highresicon;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MultiResolutionImage;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.highresicon.IconScale;
import net.sourceforge.squirrel_sql.plugins.highresicon.ImageScaler;
import net.sourceforge.squirrel_sql.plugins.highresicon.MultiResolutionCachedImage;

public class SquirrelIconImage
extends MultiResolutionCachedImage {
    private static final Pattern SCALE_FACTOR_IN_PATH = Pattern.compile("(?x) [^/] @([1-6])x (?:\\.[^./]+)? $");
    private static ILogger log = LoggerController.createLogger(SquirrelIconImage.class);
    private static ImageScaler imageScaler = ImageScaler.getInstance();
    private final URL sourceLocation;
    private final Image sourceImage;
    private final boolean iconImage;

    protected SquirrelIconImage(URL sourceLocation, Image sourceImage, int baseWidth, int baseHeight) {
        super(baseWidth, baseHeight);
        this.sourceLocation = sourceLocation;
        this.sourceImage = sourceImage;
        this.iconImage = baseWidth > 0 && baseWidth <= 64 && baseHeight > 0 && baseHeight <= 64;
    }

    public static SquirrelIconImage of(URL sourceLocation) {
        Image sourceImage = SquirrelIconImage.loadImage(sourceLocation);
        Matcher m = SCALE_FACTOR_IN_PATH.matcher(sourceLocation.getPath());
        double sourceScale = m.find() ? Double.parseDouble(m.group(1)) : 1.0;
        int baseWidth = (int)Math.round((double)sourceImage.getWidth(null) / sourceScale);
        int baseHeight = (int)Math.round((double)sourceImage.getHeight(null) / sourceScale);
        return new SquirrelIconImage(sourceLocation, sourceImage, baseWidth, baseHeight);
    }

    public SquirrelIconImage withSource(Image anotherSource) {
        return new SquirrelIconImage(this.sourceLocation, anotherSource, this.baseWidth, this.baseHeight);
    }

    protected URL getSourceLocation() {
        return this.sourceLocation;
    }

    protected Image getSourceImage() {
        return this.sourceImage;
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.iconImage ? IconScale.ceil(this.baseWidth) : this.baseWidth;
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.iconImage ? IconScale.ceil(this.baseHeight) : this.baseHeight;
    }

    @Override
    public ImageProducer getSource() {
        return this.getResolutionVariant(this.getWidth(null), this.getHeight(null)).getSource();
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        URL location = this.getSourceLocation();
        if ("comment".equals(name) && location != null) {
            return location.toString();
        }
        return super.getProperty(name, observer);
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Collections.singletonList(this.getSourceImage());
    }

    @Override
    protected Image createResolutionVariant(int width, int height) {
        Image base = this.getSourceImage();
        if (base instanceof MultiResolutionImage) {
            base = ((MultiResolutionImage)((Object)base)).getResolutionVariant(width, height);
        }
        return imageScaler.scale(base, width, height);
    }

    private static Image loadImage(URL url) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return SquirrelIconImage.loadImage(toolkit.getImage(url));
    }

    private static Image loadImage(Image image) {
        ImageIcon loader = new ImageIcon(image);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Image load status=" + loader.getImageLoadStatus() + ": " + loader.getDescription()));
        }
        return loader.getImage();
    }
}

