/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.vertica.exp;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.StatementExecutionTimeOutHandler;
import net.sourceforge.squirrel_sql.plugins.vertica.VerticaObjectType;
import net.sourceforge.squirrel_sql.plugins.vertica.exp.ProjectionParentInfo;

public class ProjectionParentExpander
implements INodeExpander {
    private static final String SQL = "SELECT PROJECTION_NAME FROM V_CATALOG.PROJECTIONS WHERE PROJECTION_SCHEMA=? AND ANCHOR_TABLE_NAME=? AND PROJECTION_NAME ILIKE ? ORDER BY PROJECTION_NAME";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentInfo = parentNode.getDatabaseObjectInfo();
        String catalogName = parentInfo.getCatalogName();
        String schemaName = parentInfo.getSchemaName();
        IDatabaseObjectInfo anchorTableInfo = ((ProjectionParentInfo)parentInfo).getTableInfo();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = conn.getSQLMetaData();
        PreparedStatement pstmt = StatementExecutionTimeOutHandler.prepareStatement((ISQLConnection)conn, (String)SQL);
        ObjFilterMatcher filterMatcher = new ObjFilterMatcher(session.getProperties());
        ResultSet rs = null;
        try {
            pstmt.setString(1, schemaName);
            pstmt.setString(2, anchorTableInfo.getSimpleName());
            pstmt.setString(3, filterMatcher.getSqlLikeMatchString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DatabaseObjectInfo si = new DatabaseObjectInfo(catalogName, schemaName, rs.getString(1), VerticaObjectType.PROJECTION, (ISQLDatabaseMetaData)md);
                childNodes.add(new ObjectTreeNode(session, (IDatabaseObjectInfo)si));
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            SQLUtilities.closeStatement((Statement)pstmt);
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)pstmt);
        return childNodes;
    }
}

