/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.vertica.exp;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.timeoutproxy.StatementExecutionTimeOutHandler;

public class SysTableParentExpander
implements INodeExpander {
    private static final String SQL = "SELECT TABLE_NAME, TABLE_DESCRIPTION FROM V_CATALOG.SYSTEM_TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME ILIKE ? ORDER BY TABLE_NAME";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        String catalogName = parentNode.getDatabaseObjectInfo().getCatalogName();
        String schemaName = parentNode.getDatabaseObjectInfo().getSchemaName();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = conn.getSQLMetaData();
        PreparedStatement pstmt = StatementExecutionTimeOutHandler.prepareStatement((ISQLConnection)conn, (String)SQL);
        ObjFilterMatcher filterMatcher = new ObjFilterMatcher(session.getProperties());
        ResultSet rs = null;
        try {
            pstmt.setString(1, schemaName);
            pstmt.setString(2, filterMatcher.getSqlLikeMatchString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                TableInfo si = new TableInfo(catalogName, schemaName, rs.getString(1).toUpperCase(), "SYSTEM TABLE", rs.getString(2), (ISQLDatabaseMetaData)md);
                childNodes.add(new ObjectTreeNode(session, (IDatabaseObjectInfo)si));
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            SQLUtilities.closeStatement((Statement)pstmt);
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)pstmt);
        return childNodes;
    }
}

