/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.vertica.tab;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.table.BaseTableTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ProjectionTab
extends BaseTableTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ProjectionTab.class);
    private static final String SQL = "SELECT PROJECTION_NAME,OWNER_NAME AS OWNER,NODE_NAME,IS_PREJOIN,CREATED_EPOCH,CREATE_TYPE,VERIFIED_FAULT_TOLERANCE AS K_SAFETY_VALUE,IS_UP_TO_DATE,HAS_STATISTICS FROM V_CATALOG.PROJECTIONS WHERE PROJECTION_SCHEMA=? AND ANCHOR_TABLE_NAME=?";

    public String getTitle() {
        return i18n.TITLE;
    }

    public String getHint() {
        return i18n.HINT;
    }

    protected IDataSet createDataSet() throws DataSetException {
        ResultSetDataSet resultSetDataSet;
        PreparedStatement pstmt;
        ISQLConnection conn = this.getSession().getSQLConnection();
        SQLDatabaseMetaData md = conn.getSQLMetaData();
        ResultSet rs = null;
        String sql = SQL;
        try {
            pstmt = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new DataSetException((Throwable)e);
        }
        try {
            ITableInfo ti = this.getTableInfo();
            pstmt.setString(1, ti.getSchemaName());
            pstmt.setString(2, ti.getSimpleName());
            rs = pstmt.executeQuery();
            ResultSetDataSet rsds = new ResultSetDataSet(md.getColumnInfo(ti));
            rsds.setResultSet(rs, DialectFactory.getDialectType((ISQLDatabaseMetaData)md));
            resultSetDataSet = rsds;
        }
        catch (SQLException e) {
            try {
                throw new DataSetException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)pstmt);
        return resultSetDataSet;
    }

    private static interface i18n {
        public static final String HINT = s_stringMgr.getString("ProjectionTab.hint");
        public static final String TITLE = s_stringMgr.getString("ProjectionTab.title");
    }
}

