/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.db2;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.db2.DB2JCCExceptionFormatter;
import net.sourceforge.squirrel_sql.plugins.db2.exp.DB2TableIndexExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.db2.exp.DB2TableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.db2.exp.SchemaExpander;
import net.sourceforge.squirrel_sql.plugins.db2.sql.DB2SqlImpl;
import net.sourceforge.squirrel_sql.plugins.db2.tab.DB2SpecificColumnDetailsTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.IndexDetailsTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.ProcedureSourceTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.SequenceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.TableSourceTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.UDFDetailsTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.UDFSourceTab;
import net.sourceforge.squirrel_sql.plugins.db2.tab.ViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.db2.types.DB2XmlTypeDataTypeComponentFactory;

public class DB2Plugin
extends DefaultSessionPlugin {
    public static final String[] JCC_DRIVER_NAME = new String[]{"IBM DB2 JDBC Universal Driver Architecture", "IBM Data Server Driver for JDBC and SQLJ"};
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DB2Plugin.class);
    private static final ILogger s_log = LoggerController.createLogger(DB2Plugin.class);

    public String getInternalName() {
        return "db2";
    }

    public String getDescriptiveName() {
        return "DB2 Plugin";
    }

    public String getVersion() {
        return "0.05";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "Christoph Schmitz, Tilmann Brenk, Lars Heller";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        Main.getApplication().getDataTypeComponentFactoryRegistry().registerDataTypeFactory((IDataTypeComponentFactory)new DB2XmlTypeDataTypeComponentFactory());
    }

    public void unload() {
        super.unload();
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread(() -> this.updateTreeApi(session.getSessionInternalFrame().getObjectTreeAPI()));
        try {
            String driverName = session.getMetaData().getJDBCMetaData().getDriverName();
            for (String n : JCC_DRIVER_NAME) {
                if (!n.equals(driverName)) continue;
                s_log.info((Object)("SELECTED DRIVER NAME: " + n));
                session.setExceptionFormatter((ExceptionFormatter)new DB2JCCExceptionFormatter());
                break;
            }
        }
        catch (SQLException e) {
            s_log.error((Object)("Problem installing exception formatter: " + e.getMessage()));
        }
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                DB2Plugin.this.updateTreeApi(objectTreeInternalFrame.getObjectTreeAPI());
            }

            public void objectTreeInSQLTabOpened(ObjectTreePanel objectTreePanel) {
                DB2Plugin.this.updateTreeApi((IObjectTreeAPI)objectTreePanel);
            }
        };
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isDB2((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(IObjectTreeAPI objectTreeAPI) {
        String databaseProductName = this.getDatabaseProductName(objectTreeAPI.getSession());
        DB2SqlImpl db2Sql = new DB2SqlImpl(databaseProductName);
        String stmtSep = objectTreeAPI.getSession().getQueryTokenizer().getSQLStatementSeparator();
        objectTreeAPI.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)new ProcedureSourceTab(i18n.SHOW_PROCEDURE_SOURCE, stmtSep, db2Sql));
        objectTreeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE, stmtSep, db2Sql));
        objectTreeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexDetailsTab(db2Sql));
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new SequenceDetailsTab(db2Sql));
        objectTreeAPI.addDetailTab(DatabaseObjectType.UDF, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.UDF, (IObjectTab)new UDFSourceTab(i18n.SHOW_UDF_SOURCE, stmtSep, db2Sql));
        objectTreeAPI.addDetailTab(DatabaseObjectType.UDF, (IObjectTab)new UDFDetailsTab(db2Sql));
        objectTreeAPI.addDetailTab(DatabaseObjectType.TABLE, (IObjectTab)new TableSourceTab("Show MQT Source", stmtSep, db2Sql));
        objectTreeAPI.addDetailTab(DatabaseObjectType.TABLE, (IObjectTab)new DB2SpecificColumnDetailsTab(db2Sql));
        objectTreeAPI.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander(db2Sql));
        TableWithChildNodesExpander tableExpander = new TableWithChildNodesExpander();
        DB2TableIndexExtractorImpl indexExtractor = new DB2TableIndexExtractorImpl(db2Sql);
        tableExpander.setTableIndexExtractor((ITableIndexExtractor)indexExtractor);
        DB2TableTriggerExtractorImpl triggerExtractor = new DB2TableTriggerExtractorImpl(db2Sql);
        tableExpander.setTableTriggerExtractor((ITableTriggerExtractor)triggerExtractor);
        objectTreeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)tableExpander);
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab(db2Sql));
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab(i18n.SHOW_TRIGGER_SOURCE, stmtSep, db2Sql));
    }

    private String getDatabaseProductName(ISession session) {
        String result = null;
        try {
            result = session.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            s_log.error((Object)("getDatabaseProductName: unable to determine the product name (assuming LUW): " + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    static interface i18n {
        public static final String SHOW_UDF_SOURCE = s_stringMgr.getString("DB2Plugin.showUdfSource");
        public static final String SHOW_VIEW_SOURCE = s_stringMgr.getString("DB2Plugin.showViewSource");
        public static final String SHOW_PROCEDURE_SOURCE = s_stringMgr.getString("DB2Plugin.showProcedureSource");
        public static final String SHOW_TRIGGER_SOURCE = s_stringMgr.getString("DB2Plugin.showTriggerSource");
    }
}

