/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.gui.OutputLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;

class AppPreferencesPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AppPreferencesPanel.class);
    private static final String INFO = s_stringMgr.getString("sqlval.info");
    private final WebServicePreferences _prefs;
    private JCheckBox _anonLogonChk = new JCheckBox(s_stringMgr.getString("sqlval.anonymous"));
    private JCheckBox _anonClientChk = new JCheckBox(s_stringMgr.getString("sqlval.anonymous2"));
    private JTextField _userNameText = new JTextField();
    private JPasswordField _passwordText = new JPasswordField();
    private OutputLabel _clientNameLbl = new OutputLabel(" ");
    private OutputLabel _clientVersionLbl = new OutputLabel(" ");

    AppPreferencesPanel(WebServicePreferences prefs) {
        super(new GridBagLayout());
        if (prefs == null) {
            throw new IllegalArgumentException("WebServicePreferences == null");
        }
        this._prefs = prefs;
        this.createGUI();
        this.loadData();
    }

    void loadData() {
        this._anonLogonChk.setSelected(this._prefs.getUseAnonymousLogon());
        this._userNameText.setText(this._prefs.getUserName());
        this._passwordText.setText(this._prefs.retrievePassword());
        this._anonClientChk.setSelected(this._prefs.getUseAnonymousClient());
        this._clientNameLbl.setText(this._prefs.getClientName());
        this._clientVersionLbl.setText(this._prefs.getClientVersion());
        this.setControlState();
    }

    void save() {
        this._prefs.setUseAnonymousLogon(this._anonLogonChk.isSelected());
        this._prefs.setUserName(this._userNameText.getText());
        this._prefs.setPassword(new String(this._passwordText.getPassword()));
        this._prefs.setUseAnonymousClient(this._anonClientChk.isSelected());
        this._prefs.setClientName(this._clientNameLbl.getText());
        this._prefs.setClientVersion(this._clientVersionLbl.getText());
    }

    private void setControlState() {
        this.setAnonymousUserControlState(this._prefs.getUseAnonymousLogon());
    }

    private void setAnonymousUserControlState(boolean state) {
        this._userNameText.setEnabled(!state);
        this._passwordText.setEnabled(!state);
    }

    private void createGUI() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(1, 4, 1, 4);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.createInfoPanel(), gbc);
        gbc.weighty = 0.0;
        ++gbc.gridy;
        this.add((Component)this.createLogonPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.createClientPanel(), gbc);
    }

    private JPanel createInfoPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("sqlval.infoBorder")));
        pnl.setLayout(new BorderLayout());
        MultipleLineLabel lbl = new MultipleLineLabel(INFO);
        lbl.setCaretPosition(0);
        lbl.setRows(3);
        lbl.setColumns(30);
        JScrollPane sp = new JScrollPane((Component)lbl);
        sp.setBorder(BorderFactory.createEmptyBorder());
        pnl.add((Component)sp, "Center");
        return pnl;
    }

    private JPanel createLogonPanel() {
        this._userNameText.setColumns(15);
        this._passwordText.setColumns(15);
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("sqlval.loOnAs")));
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        pnl.add((Component)this._anonLogonChk, gbc);
        gbc.fill = 2;
        gbc.anchor = 13;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        ++gbc.gridx;
        pnl.add((Component)new JLabel(s_stringMgr.getString("sqlval.user"), 4), gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("sqlval.pwdPref"), 4), gbc);
        gbc.fill = 0;
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        pnl.add((Component)this._userNameText, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._passwordText, gbc);
        this._anonLogonChk.addActionListener(new AnonymousCheckBoxListener());
        return pnl;
    }

    private JPanel createClientPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("sqlval.clientBorder")));
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        pnl.add((Component)this._anonClientChk, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("sqlval.clientLogon"), 4), gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("sqlval.version"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        pnl.add((Component)this._clientNameLbl, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._clientVersionLbl, gbc);
        return pnl;
    }

    private final class AnonymousCheckBoxListener
    implements ActionListener {
        private AnonymousCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppPreferencesPanel.this.setAnonymousUserControlState(AppPreferencesPanel.this._anonLogonChk.isSelected());
        }
    }
}

