/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval;

import java.io.Serializable;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSession;

public class WebServiceSessionProperties
implements Cloneable,
Serializable {
    private static final String UNSUPPORTED = "Unsupported";
    private boolean _useAnonymousDBMS = false;
    private String _targetDBMS;
    private String _targetDBMSVersion;
    private String _connTechnology;
    private String _connTechnologyVersion;
    private transient WebServiceSession _webServiceSession;

    public WebServiceSessionProperties(WebServicePreferences prefs) {
        this._webServiceSession = new WebServiceSession(prefs, this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw Utilities.wrapRuntime((Throwable)ex);
        }
    }

    public WebServiceSession getWebServiceSession() {
        return this._webServiceSession;
    }

    public boolean getUseAnonymousDBMS() {
        return this._useAnonymousDBMS;
    }

    public void setUseAnonymousDBMS(boolean value) {
        this._useAnonymousDBMS = value;
    }

    public String getTargetDBMSName() {
        return this._targetDBMS;
    }

    public String getTargetDBMSVersion() {
        return this._targetDBMSVersion;
    }

    public String getConnectionTechnology() {
        return this._connTechnology;
    }

    public String getConnectionTechnologyVersion() {
        return this._connTechnologyVersion;
    }

    public void setSQLConnection(ISQLConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        SQLDatabaseMetaData md = conn.getSQLMetaData();
        try {
            this._targetDBMS = md.getDatabaseProductName();
        }
        catch (Throwable ignore) {
            this._targetDBMS = UNSUPPORTED;
        }
        try {
            this._targetDBMSVersion = md.getDatabaseProductVersion();
            if (this._targetDBMSVersion.length() > 30) {
                this._targetDBMSVersion = this._targetDBMSVersion.substring(0, 30);
            }
        }
        catch (Throwable ignore) {
            this._targetDBMSVersion = UNSUPPORTED;
        }
        this._connTechnology = "JDBC";
        try {
            this._connTechnologyVersion = String.valueOf(md.getJDBCVersion());
        }
        catch (Throwable ignore) {
            this._connTechnologyVersion = UNSUPPORTED;
        }
    }
}

