/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff.myers;

import java.util.HashMap;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.DiffAlgorithm;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.myers.DiffNode;
import org.apache.commons.jrcs.diff.myers.PathNode;
import org.apache.commons.jrcs.diff.myers.Snake;
import org.jmeld.diff.MaxTimeExceededException;

public class MyersDiff
implements DiffAlgorithm {
    private static int MAXTIME = 3000;
    public boolean checkMaxTime = false;

    public void checkMaxTime(boolean checkMaxTime) {
        this.checkMaxTime = checkMaxTime;
    }

    @Override
    public Revision diff(Object[] orig, Object[] rev) throws DifferentiationFailedException {
        PathNode path = this.buildPath(orig, rev);
        return this.buildRevision(path, orig, rev);
    }

    public PathNode buildPath(Object[] orig, Object[] rev) throws DifferentiationFailedException {
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        int N = orig.length;
        int M = rev.length;
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = (size + 1) / 2;
        HashMap<Integer, PathNode> diagonal = new HashMap<Integer, PathNode>();
        Object path = null;
        long startTime = System.currentTimeMillis();
        diagonal.put(middle + 1, new Snake(0, -1, null));
        for (int d = 0; d < MAX; ++d) {
            if (this.checkMaxTime && System.currentTimeMillis() - startTime > (long)MAXTIME) {
                throw new MaxTimeExceededException("Algoritm is taking up to much time");
            }
            for (int k = -d; k <= d; k += 2) {
                int j;
                int i;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                PathNode d_kminus = (PathNode)diagonal.get(kminus);
                PathNode d_kplus = (PathNode)diagonal.get(kplus);
                if (k == -d || k != d && d_kminus.i < d_kplus.i) {
                    i = d_kplus.i;
                    prev = d_kplus;
                } else {
                    i = d_kminus.i + 1;
                    prev = d_kminus;
                }
                diagonal.remove(kminus);
                PathNode node = new DiffNode(i, j, prev);
                for (j = i - k; i < N && j < M && orig[i].equals(rev[j]); ++i, ++j) {
                }
                if (i > node.i) {
                    node = new Snake(i, j, node);
                }
                diagonal.put(kmiddle, node);
                if (i < N || j < M) continue;
                return (PathNode)diagonal.get(kmiddle);
            }
            diagonal.put(middle + d - 1, null);
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }

    private boolean isEmpty(Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        String s = (String)o;
        return s == null || s.trim().compareTo("") == 0;
    }

    public Revision buildRevision(PathNode path, Object[] orig, Object[] rev) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        Revision revision = new Revision();
        if (path.isSnake()) {
            path = path.prev;
        }
        while (path != null && path.prev != null && path.prev.j >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.i;
            int j = path.j;
            path = path.prev;
            int ianchor = path.i;
            int janchor = path.j;
            Delta delta = Delta.newDelta(new Chunk(orig, ianchor, i - ianchor), new Chunk(rev, janchor, j - janchor));
            revision.insertDelta(delta);
            if (!path.isSnake()) continue;
            path = path.prev;
        }
        return revision;
    }
}

