/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeld.tools.ant;

import java.io.PrintStream;
import java.io.PrintWriter;

public class BuildException
extends RuntimeException {
    private Throwable cause;

    public BuildException() {
    }

    public BuildException(String message) {
        super(message);
    }

    public BuildException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public BuildException(Throwable cause) {
        super(cause.toString());
        this.cause = cause;
    }

    public Throwable getException() {
        return this.cause;
    }

    @Override
    public Throwable getCause() {
        return this.getException();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
            if (this.cause != null) {
                ps.println("--- Nested Exception ---");
                this.cause.printStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            if (this.cause != null) {
                pw.println("--- Nested Exception ---");
                this.cause.printStackTrace(pw);
            }
        }
    }
}

