/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeld.tools.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.jmeld.tools.ant.BuildException;
import org.apache.jmeld.tools.ant.taskdefs.condition.Os;
import org.apache.jmeld.tools.ant.types.Resource;
import org.apache.jmeld.tools.ant.types.ResourceFactory;
import org.apache.jmeld.tools.ant.types.selectors.FileSelector;
import org.apache.jmeld.tools.ant.types.selectors.SelectorScanner;
import org.apache.jmeld.tools.ant.types.selectors.SelectorUtils;
import org.apache.jmeld.tools.ant.util.FileUtils;
import org.jmeld.ui.StatusBar;
import org.jmeld.util.node.FileNode;

public class DirectoryScanner
implements SelectorScanner,
ResourceFactory {
    private static final boolean ON_VMS = Os.isFamily("openvms");
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final boolean[] CS_SCAN_ONLY = new boolean[]{true};
    private static final boolean[] CS_THEN_NON_CS = new boolean[]{true, false};
    private boolean showStateOn;
    protected File basedir;
    protected List<String> includes = Arrays.asList("**");
    protected List<String> excludes = new ArrayList<String>();
    protected FileSelector[] selectors = null;
    protected List filesIncluded;
    protected Map<String, FileNode> filesIncludedMap;
    protected List filesNotIncluded;
    protected List filesExcluded;
    protected List<String> dirsIncluded;
    protected Map<String, FileNode> dirsIncludedMap;
    protected List<String> dirsNotIncluded;
    protected List<String> dirsExcluded;
    protected List<String> filesDeselected;
    protected List<String> dirsDeselected;
    protected boolean haveSlowResults = false;
    protected boolean isCaseSensitive = true;
    private boolean followSymlinks = true;
    protected boolean everythingIncluded = true;
    private Map fileListMap = new HashMap();
    private Set scannedDirs = new HashSet();
    private List<String> includeNonPatterns = new ArrayList<String>();
    private List<String> excludeNonPatterns = new ArrayList<String>();
    private List<String> includePatterns;
    private List<String> excludePatterns;
    private boolean areNonPatternSetsReady = false;
    private boolean scanning = false;
    private Object scanLock = new Object();
    private boolean slowScanning = false;
    private Object slowScanLock = new Object();
    private IllegalStateException illegal = null;

    protected static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str);
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern, str, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str);
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str, isCaseSensitive);
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.match(pattern, str, isCaseSensitive);
    }

    public void setBasedir(String basedir) {
        this.setBasedir(new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public synchronized void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public synchronized File getBasedir() {
        return this.basedir;
    }

    public synchronized boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public synchronized void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public synchronized boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public synchronized void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public synchronized void setIncludes(List<String> includes) {
        if (includes == null || includes.size() == 0) {
            this.includes = Arrays.asList("**");
        } else {
            this.includes = new ArrayList<String>(includes.size());
            for (String include : includes) {
                this.includes.add(DirectoryScanner.normalizePattern(include));
            }
        }
    }

    public synchronized void setExcludes(List<String> excludes) {
        if (excludes == null) {
            this.excludes = new ArrayList<String>();
        } else {
            this.excludes = new ArrayList<String>(excludes.size());
            for (String exclude : excludes) {
                this.excludes.add(DirectoryScanner.normalizePattern(exclude));
            }
        }
    }

    public synchronized void addExcludes(List<String> excludes) {
        if (excludes != null && excludes.size() > 0) {
            this.excludes.addAll(excludes);
        }
    }

    private static String normalizePattern(String p) {
        Object pattern = p.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (((String)pattern).endsWith(File.separator)) {
            pattern = (String)pattern + "**";
        }
        return pattern;
    }

    @Override
    public synchronized void setSelectors(FileSelector[] selectors) {
        this.selectors = selectors;
    }

    public synchronized boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() throws IllegalStateException {
        Object object = this.scanLock;
        synchronized (object) {
            if (this.scanning) {
                while (this.scanning) {
                    try {
                        this.scanLock.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (this.illegal != null) {
                    throw this.illegal;
                }
                return;
            }
            this.scanning = true;
        }
        try {
            object = this;
            synchronized (object) {
                this.illegal = null;
                this.clearResults();
                if (this.basedir == null) {
                    this.illegal = new IllegalStateException("No basedir set");
                } else {
                    if (!this.basedir.exists()) {
                        this.illegal = new IllegalStateException("basedir " + this.basedir + " does not exist");
                    }
                    if (!this.basedir.isDirectory()) {
                        this.illegal = new IllegalStateException("basedir " + this.basedir + " is not a directory");
                    }
                }
                if (this.illegal != null) {
                    throw this.illegal;
                }
                if (this.isIncluded("")) {
                    if (!this.isExcluded("")) {
                        if (this.isSelected("", this.basedir)) {
                            this.dirsIncluded.add("");
                        } else {
                            this.dirsDeselected.add("");
                        }
                    } else {
                        this.dirsExcluded.add("");
                    }
                } else {
                    this.dirsNotIncluded.add("");
                }
                this.checkIncludePatterns();
                this.clearCaches();
            }
        }
        finally {
            object = this.scanLock;
            synchronized (object) {
                this.scanning = false;
                this.scanLock.notifyAll();
            }
        }
    }

    private void checkIncludePatterns() {
        Hashtable<String, String> newroots = new Hashtable<String, String>();
        for (String include : this.includes) {
            newroots.put(SelectorUtils.rtrimWildcardTokens(include), include);
        }
        if (newroots.containsKey("")) {
            this.scandir(this.basedir, "", true);
        } else {
            Enumeration enum2 = newroots.keys();
            File canonBase = null;
            try {
                canonBase = this.basedir.getCanonicalFile();
            }
            catch (IOException ex) {
                throw new BuildException(ex);
            }
            while (enum2.hasMoreElements()) {
                File f;
                Object currentelement = (String)enum2.nextElement();
                String originalpattern = (String)newroots.get(currentelement);
                File myfile = new File(this.basedir, (String)currentelement);
                if (myfile.exists()) {
                    try {
                        File canonFile = myfile.getCanonicalFile();
                        String path = FILE_UTILS.removeLeadingPath(canonBase, canonFile);
                        if ((!path.equals(currentelement) || ON_VMS) && (myfile = this.findFile(this.basedir, (String)currentelement, true)) != null) {
                            currentelement = FILE_UTILS.removeLeadingPath(this.basedir, myfile);
                        }
                    }
                    catch (IOException ex) {
                        throw new BuildException(ex);
                    }
                }
                if (!(myfile != null && myfile.exists() || this.isCaseSensitive() || (f = this.findFile(this.basedir, (String)currentelement, false)) == null || !f.exists())) {
                    currentelement = FILE_UTILS.removeLeadingPath(this.basedir, f);
                    myfile = f;
                }
                if (myfile == null || !myfile.exists() || !this.followSymlinks && this.isSymlink(this.basedir, (String)currentelement)) continue;
                if (myfile.isDirectory()) {
                    if (this.isIncluded((String)currentelement) && ((String)currentelement).length() > 0) {
                        this.accountForIncludedDir((String)currentelement, myfile, true);
                        continue;
                    }
                    if (((String)currentelement).length() > 0 && ((String)currentelement).charAt(((String)currentelement).length() - 1) != File.separatorChar) {
                        currentelement = (String)currentelement + File.separatorChar;
                    }
                    this.scandir(myfile, (String)currentelement, true);
                    continue;
                }
                boolean included = this.isCaseSensitive() ? originalpattern.equals(currentelement) : originalpattern.equalsIgnoreCase((String)currentelement);
                if (!included) continue;
                this.accountForIncludedFile((String)currentelement, myfile, null);
            }
        }
    }

    protected synchronized void clearResults() {
        this.filesIncluded = new ArrayList();
        this.filesIncludedMap = new HashMap<String, FileNode>();
        this.filesNotIncluded = new ArrayList();
        this.filesExcluded = new ArrayList();
        this.filesDeselected = new ArrayList<String>();
        this.dirsIncluded = new ArrayList<String>();
        this.dirsIncludedMap = new HashMap<String, FileNode>();
        this.dirsNotIncluded = new ArrayList<String>();
        this.dirsExcluded = new ArrayList<String>();
        this.dirsDeselected = new ArrayList<String>();
        this.everythingIncluded = this.basedir != null;
        this.scannedDirs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void slowScan() {
        Object object = this.slowScanLock;
        synchronized (object) {
            if (this.haveSlowResults) {
                return;
            }
            if (this.slowScanning) {
                while (this.slowScanning) {
                    try {
                        this.slowScanLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            this.slowScanning = true;
        }
        try {
            object = this;
            synchronized (object) {
                for (String excluded : this.dirsExcluded) {
                    if (this.couldHoldIncluded(excluded)) continue;
                    this.scandir(new File(this.basedir, excluded), excluded + File.separator, false);
                }
                for (String notIncluded : this.dirsNotIncluded) {
                    if (this.couldHoldIncluded(notIncluded)) continue;
                    this.scandir(new File(this.basedir, notIncluded), notIncluded + File.separator, false);
                }
                this.clearCaches();
            }
        }
        finally {
            object = this.slowScanLock;
            synchronized (object) {
                this.haveSlowResults = true;
                this.slowScanning = false;
                this.slowScanLock.notifyAll();
            }
        }
    }

    protected void scandir(File dir, String vpath, boolean fast) {
        if (dir == null) {
            throw new BuildException("dir must not be null.");
        }
        if (!dir.exists()) {
            throw new BuildException(dir + " doesn't exists.");
        }
        if (!dir.isDirectory()) {
            throw new BuildException(dir + " is not a directory.");
        }
        if (fast && this.hasBeenScanned(dir)) {
            return;
        }
        this.setState("Scan directory: %s", vpath);
        String[] newfiles = dir.list();
        if (newfiles == null) {
            throw new BuildException("IO error scanning directory " + dir.getAbsolutePath());
        }
        if (!this.followSymlinks) {
            ArrayList<String> noLinks = new ArrayList<String>();
            for (int i = 0; i < newfiles.length; ++i) {
                try {
                    if (FILE_UTILS.isSymbolicLink(dir, newfiles[i])) {
                        String name = vpath + newfiles[i];
                        File file = new File(dir, newfiles[i]);
                        (file.isDirectory() ? this.dirsExcluded : this.filesExcluded).add(name);
                        continue;
                    }
                    noLinks.add(newfiles[i]);
                    continue;
                }
                catch (IOException ioe) {
                    String msg = "IOException caught while checking for links, couldn't get canonical path!";
                    System.err.println(msg);
                    noLinks.add(newfiles[i]);
                }
            }
            newfiles = noLinks.toArray(new String[noLinks.size()]);
        }
        for (int i = 0; i < newfiles.length; ++i) {
            String name = vpath + newfiles[i];
            File file = new File(dir, newfiles[i]);
            if (file.isDirectory()) {
                if (this.isIncluded(name)) {
                    this.accountForIncludedDir(name, file, fast);
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.add(name);
                    if (fast && this.couldHoldIncluded(name) && !this.contentsExcluded(name)) {
                        this.scandir(file, name + File.separator, fast);
                    }
                }
                if (fast) continue;
                this.scandir(file, name + File.separator, fast);
                continue;
            }
            if (!file.isFile()) continue;
            if (this.isIncluded(name)) {
                this.accountForIncludedFile(name, file, dir);
                continue;
            }
            this.everythingIncluded = false;
            this.filesNotIncluded.add(name);
        }
    }

    private void accountForIncludedFile(String name, File file, File dir) {
        if (this.filesIncludedMap.get(name) != null || this.filesExcluded.contains(name) || this.filesDeselected.contains(name)) {
            return;
        }
        boolean included = false;
        if (this.isExcluded(name)) {
            this.filesExcluded.add(name);
        } else if (this.isSelected(name, file)) {
            included = true;
            this.filesIncluded.add(name);
            this.filesIncludedMap.put(name, new FileNode(name, file));
        } else {
            this.filesDeselected.add(name);
        }
        this.everythingIncluded &= included;
    }

    private void accountForIncludedDir(String name, File file, boolean fast) {
        if (this.dirsIncluded.contains(name) || this.dirsExcluded.contains(name) || this.dirsDeselected.contains(name)) {
            return;
        }
        boolean included = false;
        if (this.isExcluded(name)) {
            this.dirsExcluded.add(name);
        } else if (this.isSelected(name, file)) {
            included = true;
            this.dirsIncluded.add(name);
            this.dirsIncludedMap.put(name, new FileNode(name, file));
        } else {
            this.dirsDeselected.add(name);
        }
        this.everythingIncluded &= included;
        if (fast && this.couldHoldIncluded(name) && !this.contentsExcluded(name)) {
            this.scandir(file, name + File.separator, fast);
        }
    }

    protected boolean isIncluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.includeNonPatterns.contains(name) : this.includeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        for (String includePattern : this.includePatterns) {
            if (!DirectoryScanner.matchPath(includePattern, name, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        if (!this.isMorePowerfulThanExcludes(name, null)) {
            return false;
        }
        for (String include : this.includes) {
            if (!DirectoryScanner.matchPatternStart(include, name, this.isCaseSensitive()) || !this.isMorePowerfulThanExcludes(name, include) || !this.isDeeper(include, name)) continue;
            return true;
        }
        return false;
    }

    private boolean isDeeper(String pattern, String name) {
        Vector p = SelectorUtils.tokenizePath(pattern);
        Vector n = SelectorUtils.tokenizePath(name);
        return p.contains("**") || p.size() > n.size();
    }

    private boolean isMorePowerfulThanExcludes(String name, String includepattern) {
        String soughtexclude = name + File.separator + "**";
        for (String exclude : this.excludes) {
            if (!exclude.equals(soughtexclude)) continue;
            return false;
        }
        return true;
    }

    private boolean contentsExcluded(String name) {
        name = name.endsWith(File.separator) ? name : name + File.separator;
        for (String exclude : this.excludes) {
            if (!exclude.endsWith("**") || !SelectorUtils.matchPath(exclude.substring(0, exclude.length() - 2), name, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.excludeNonPatterns.contains(name) : this.excludeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        for (String excludePattern : this.excludePatterns) {
            if (!DirectoryScanner.matchPath(excludePattern, name, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelected(String name, File file) {
        if (this.selectors != null) {
            for (int i = 0; i < this.selectors.length; ++i) {
                if (this.selectors[i].isSelected(this.basedir, name, file)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized List<String> getIncludedFiles() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException();
        }
        Collections.sort(this.filesIncluded);
        return this.filesIncluded;
    }

    public synchronized Map<String, FileNode> getIncludedFilesMap() {
        return this.filesIncludedMap;
    }

    public synchronized int getIncludedFilesCount() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException();
        }
        return this.filesIncluded.size();
    }

    public synchronized List<String> getNotIncludedFiles() {
        this.slowScan();
        return this.filesNotIncluded;
    }

    public synchronized List<String> getExcludedFiles() {
        this.slowScan();
        return this.filesExcluded;
    }

    @Override
    public synchronized String[] getDeselectedFiles() {
        this.slowScan();
        return this.filesDeselected.toArray(new String[this.filesDeselected.size()]);
    }

    public synchronized List<String> getIncludedDirectories() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException();
        }
        Collections.sort(this.dirsIncluded);
        return this.dirsIncluded;
    }

    public synchronized Map<String, FileNode> getIncludedDirectoriesMap() {
        return this.dirsIncludedMap;
    }

    public synchronized int getIncludedDirsCount() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException();
        }
        return this.dirsIncluded.size();
    }

    public synchronized List<String> getNotIncludedDirectories() {
        this.slowScan();
        return this.dirsNotIncluded;
    }

    public synchronized List<String> getExcludedDirectories() {
        this.slowScan();
        return this.dirsExcluded;
    }

    @Override
    public synchronized String[] getDeselectedDirectories() {
        this.slowScan();
        return this.dirsDeselected.toArray(new String[this.dirsDeselected.size()]);
    }

    @Override
    public synchronized Resource getResource(String name) {
        File f = FILE_UTILS.resolveFile(this.basedir, name);
        return new Resource(name, f.exists(), f.lastModified(), f.isDirectory(), f.length());
    }

    private String[] list(File file) {
        String[] files = (String[])this.fileListMap.get(file);
        if (files == null && (files = file.list()) != null) {
            this.fileListMap.put(file, files);
        }
        return files;
    }

    private File findFile(File base, String path, boolean cs) {
        return this.findFile(base, SelectorUtils.tokenizePath(path), cs);
    }

    private File findFile(File base, List pathElements, boolean cs) {
        if (pathElements.size() == 0) {
            return base;
        }
        if (!base.isDirectory()) {
            return null;
        }
        String[] files = this.list(base);
        if (files == null) {
            throw new BuildException("IO error scanning directory " + base.getAbsolutePath());
        }
        String current = (String)pathElements.remove(0);
        boolean[] matchCase = cs ? CS_SCAN_ONLY : CS_THEN_NON_CS;
        for (int i = 0; i < matchCase.length; ++i) {
            for (int j = 0; j < files.length; ++j) {
                if (!(matchCase[i] ? files[j].equals(current) : files[j].equalsIgnoreCase(current))) continue;
                return this.findFile(new File(base, files[j]), pathElements, cs);
            }
        }
        return null;
    }

    private boolean isSymlink(File base, String path) {
        return this.isSymlink(base, SelectorUtils.tokenizePath(path));
    }

    private boolean isSymlink(File base, List pathElements) {
        if (pathElements.size() > 0) {
            String current = (String)pathElements.remove(0);
            try {
                return FILE_UTILS.isSymbolicLink(base, current) || this.isSymlink(new File(base, current), pathElements);
            }
            catch (IOException ioe) {
                String msg = "IOException caught while checking for links, couldn't get canonical path!";
                System.err.println(msg);
            }
        }
        return false;
    }

    private boolean hasBeenScanned(File dir) {
        try {
            return !this.scannedDirs.add(dir.getCanonicalFile());
        }
        catch (IOException ex) {
            return true;
        }
    }

    Set getScannedDirs() {
        return this.scannedDirs;
    }

    private synchronized void clearCaches() {
        this.fileListMap.clear();
        this.includeNonPatterns.clear();
        this.excludeNonPatterns.clear();
        this.includePatterns = new ArrayList<String>();
        this.excludePatterns = new ArrayList<String>();
        this.areNonPatternSetsReady = false;
    }

    private synchronized void ensureNonPatternSetsReady() {
        if (!this.areNonPatternSetsReady) {
            this.includePatterns = this.fillNonPatternSet(this.includeNonPatterns, this.includes);
            this.excludePatterns = this.fillNonPatternSet(this.excludeNonPatterns, this.excludes);
            this.areNonPatternSetsReady = true;
        }
    }

    private List<String> fillNonPatternSet(List<String> set, List<String> patterns) {
        ArrayList<String> al = new ArrayList<String>(patterns.size());
        for (String pattern : patterns) {
            if (!SelectorUtils.hasWildcards(pattern)) {
                set.add(this.isCaseSensitive() ? pattern : pattern.toUpperCase());
                continue;
            }
            al.add(pattern);
        }
        return set.size() == 0 ? patterns : al;
    }

    private void setState(String format, Object ... args) {
        if (this.showStateOn) {
            StatusBar.getInstance().setState(format, args);
        }
    }

    public void setShowStateOn(boolean showStateOn) {
        this.showStateOn = showStateOn;
    }
}

